/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.util;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.ByteBuffer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.jdbi.v3.core.argument.AbstractArgumentFactory;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.internal.strategies.LoggableBinderArgument;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.statement.StatementContext;

public final class UuidUtil {
    private UuidUtil() {
    }

    public static UUID uuidFromBytes(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        long msb = buffer.getLong();
        long lsb = buffer.getLong();
        return new UUID(msb, lsb);
    }

    public static byte[] uuidToBytes(UUID uuid) {
        return ByteBuffer.allocate(16).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits()).array();
    }

    public static Slice uuidStringToBytes(Slice uuidSlice) {
        UUID uuid = UUID.fromString(uuidSlice.toStringUtf8());
        byte[] bytes = UuidUtil.uuidToBytes(uuid);
        return Slices.wrappedBuffer((byte[])bytes);
    }

    public static final class UuidColumnMapper
    implements ColumnMapper<UUID> {
        public UUID map(ResultSet r, int index, StatementContext ctx) throws SQLException {
            return UuidUtil.uuidFromBytes(r.getBytes(index));
        }
    }

    public static final class UuidArgumentFactory
    extends AbstractArgumentFactory<UUID> {
        public UuidArgumentFactory() {
            super(-3);
        }

        protected Argument build(UUID uuid, ConfigRegistry config) {
            return new LoggableBinderArgument((Object)uuid, (statement, index, value) -> statement.setBytes(index, UuidUtil.uuidToBytes(value)));
        }
    }
}

