/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import io.airlift.bootstrap.LifeCycleManager;
import io.trino.plugin.cassandra.CassandraMetadata;
import io.trino.plugin.cassandra.CassandraPageSinkProvider;
import io.trino.plugin.cassandra.CassandraRecordSetProvider;
import io.trino.plugin.cassandra.CassandraSessionProperties;
import io.trino.plugin.cassandra.CassandraSplitManager;
import io.trino.plugin.cassandra.CassandraTransactionHandle;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.transaction.IsolationLevel;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class CassandraConnector
implements Connector {
    private final LifeCycleManager lifeCycleManager;
    private final CassandraMetadata metadata;
    private final CassandraSplitManager splitManager;
    private final ConnectorRecordSetProvider recordSetProvider;
    private final ConnectorPageSinkProvider pageSinkProvider;
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public CassandraConnector(LifeCycleManager lifeCycleManager, CassandraMetadata metadata, CassandraSplitManager splitManager, CassandraRecordSetProvider recordSetProvider, CassandraPageSinkProvider pageSinkProvider, CassandraSessionProperties sessionProperties) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.recordSetProvider = Objects.requireNonNull(recordSetProvider, "recordSetProvider is null");
        this.pageSinkProvider = Objects.requireNonNull(pageSinkProvider, "pageSinkProvider is null");
        this.sessionProperties = Objects.requireNonNull(sessionProperties.getSessionProperties(), "sessionProperties is null");
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
        IsolationLevel.checkConnectorSupports((IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (IsolationLevel)isolationLevel);
        return CassandraTransactionHandle.INSTANCE;
    }

    public ConnectorMetadata getMetadata(ConnectorSession session, ConnectorTransactionHandle transactionHandle) {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorRecordSetProvider getRecordSetProvider() {
        return this.recordSetProvider;
    }

    public ConnectorPageSinkProvider getPageSinkProvider() {
        return this.pageSinkProvider;
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public final void shutdown() {
        this.lifeCycleManager.stop();
    }
}

