/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.cassandra.CassandraSession;
import io.trino.plugin.cassandra.CassandraType;
import io.trino.plugin.cassandra.CassandraTypeManager;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.Type;
import java.util.List;

public class CassandraRecordCursor
implements RecordCursor {
    private final List<CassandraType> cassandraTypes;
    private final CassandraTypeManager cassandraTypeManager;
    private final ResultSet rs;
    private Row currentRow;

    public CassandraRecordCursor(CassandraSession cassandraSession, CassandraTypeManager cassandraTypeManager, List<CassandraType> cassandraTypes, String cql) {
        this.cassandraTypes = cassandraTypes;
        this.cassandraTypeManager = cassandraTypeManager;
        this.rs = cassandraSession.execute(cql);
        this.currentRow = null;
    }

    public boolean advanceNextPosition() {
        Row row = (Row)this.rs.one();
        if (row != null) {
            this.currentRow = row;
            return true;
        }
        return false;
    }

    public void close() {
    }

    public boolean getBoolean(int i) {
        return this.currentRow.getBool(i);
    }

    public long getCompletedBytes() {
        return 0L;
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public double getDouble(int i) {
        switch (this.getCassandraType(i).getKind()) {
            case DOUBLE: {
                return this.currentRow.getDouble(i);
            }
            case FLOAT: {
                return this.currentRow.getFloat(i);
            }
            case DECIMAL: {
                return this.currentRow.getBigDecimal(i).doubleValue();
            }
        }
        throw new IllegalStateException("Cannot retrieve double for " + this.getCassandraType(i));
    }

    public long getLong(int i) {
        switch (this.getCassandraType(i).getKind()) {
            case INT: {
                return this.currentRow.getInt(i);
            }
            case SMALLINT: {
                return this.currentRow.getShort(i);
            }
            case TINYINT: {
                return this.currentRow.getByte(i);
            }
            case BIGINT: 
            case COUNTER: {
                return this.currentRow.getLong(i);
            }
            case TIMESTAMP: {
                return DateTimeEncoding.packDateTimeWithZone((long)this.currentRow.getInstant(i).toEpochMilli(), (TimeZoneKey)TimeZoneKey.UTC_KEY);
            }
            case DATE: {
                return this.currentRow.getLocalDate(i).toEpochDay();
            }
            case FLOAT: {
                return Float.floatToRawIntBits(this.currentRow.getFloat(i));
            }
        }
        throw new IllegalStateException("Cannot retrieve long for " + this.getCassandraType(i));
    }

    private CassandraType getCassandraType(int i) {
        return this.cassandraTypes.get(i);
    }

    public Slice getSlice(int i) {
        if (this.getCassandraType(i).getKind() == CassandraType.Kind.TIMESTAMP) {
            throw new IllegalArgumentException("Timestamp column can not be accessed with getSlice");
        }
        NullableValue value = this.cassandraTypeManager.getColumnValue(this.cassandraTypes.get(i), this.currentRow, i);
        if (value.getValue() instanceof Slice) {
            return (Slice)value.getValue();
        }
        return Slices.utf8Slice((String)value.getValue().toString());
    }

    public Object getObject(int i) {
        CassandraType cassandraType = this.cassandraTypes.get(i);
        switch (cassandraType.getKind()) {
            case TUPLE: 
            case UDT: {
                return this.cassandraTypeManager.getColumnValue(cassandraType, this.currentRow, i).getValue();
            }
        }
        throw new IllegalArgumentException("getObject cannot be called for " + cassandraType);
    }

    public Type getType(int i) {
        return this.getCassandraType(i).getTrinoType();
    }

    public boolean isNull(int i) {
        if (this.getCassandraType(i).getKind() == CassandraType.Kind.TIMESTAMP) {
            return this.currentRow.getInstant(i) == null;
        }
        return this.currentRow.isNull(i);
    }
}

