/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class CassandraType {
    private final Kind kind;
    private final Type trinoType;
    private final List<CassandraType> argumentTypes;

    public CassandraType(Kind kind, Type trinoType) {
        this(kind, trinoType, (List<CassandraType>)ImmutableList.of());
    }

    @JsonCreator
    public CassandraType(@JsonProperty(value="kind") Kind kind, @JsonProperty(value="trinoType") Type trinoType, @JsonProperty(value="argumentTypes") List<CassandraType> argumentTypes) {
        this.kind = Objects.requireNonNull(kind, "kind is null");
        this.trinoType = Objects.requireNonNull(trinoType, "trinoType is null");
        this.argumentTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
    }

    @JsonProperty
    public Kind getKind() {
        return this.kind;
    }

    @JsonProperty
    public Type getTrinoType() {
        return this.trinoType;
    }

    @JsonProperty
    public List<CassandraType> getArgumentTypes() {
        return this.argumentTypes;
    }

    public String getName() {
        return this.kind.name();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CassandraType that = (CassandraType)o;
        return this.kind == that.kind && Objects.equals(this.trinoType, that.trinoType) && Objects.equals(this.argumentTypes, that.argumentTypes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.trinoType, this.argumentTypes});
    }

    public String toString() {
        Object result = String.format("%s(%s", new Object[]{this.kind, this.trinoType});
        if (!this.argumentTypes.isEmpty()) {
            result = (String)result + "; " + this.argumentTypes;
        }
        result = (String)result + ")";
        return result;
    }

    public static enum Kind {
        BOOLEAN,
        TINYINT,
        SMALLINT,
        INT,
        BIGINT,
        FLOAT,
        DOUBLE,
        DECIMAL,
        DATE,
        TIMESTAMP,
        ASCII,
        TEXT,
        VARCHAR,
        BLOB,
        UUID,
        TIMEUUID,
        COUNTER,
        VARINT,
        INET,
        CUSTOM,
        LIST,
        SET,
        MAP,
        TUPLE,
        UDT;

    }
}

