/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieColumnProjectionUtils {
    public static final Logger LOG = LoggerFactory.getLogger(ColumnProjectionUtils.class);
    public static final String READ_COLUMN_IDS_CONF_STR = "hive.io.file.readcolumn.ids";
    public static final String READ_COLUMN_NAMES_CONF_STR = "hive.io.file.readcolumn.names";
    private static final String READ_COLUMN_IDS_CONF_STR_DEFAULT = "";
    private static final String READ_COLUMN_NAMES_CONF_STR_DEFAULT = "";

    public static List<Integer> getReadColumnIDs(Configuration conf) {
        String skips = conf.get(READ_COLUMN_IDS_CONF_STR, "");
        String[] list = StringUtils.split((String)skips);
        ArrayList<Integer> result = new ArrayList<Integer>(list.length);
        for (String element : list) {
            Integer toAdd = Integer.parseInt(element);
            if (result.contains(toAdd)) continue;
            result.add(toAdd);
        }
        return result;
    }

    public static String[] getReadColumnNames(Configuration conf) {
        String colNames = conf.get(READ_COLUMN_NAMES_CONF_STR, "");
        if (colNames != null && !colNames.isEmpty()) {
            return colNames.split(",");
        }
        return new String[0];
    }

    public static List<String> getIOColumns(Configuration conf) {
        String colNames = conf.get("columns", "");
        if (colNames != null && !colNames.isEmpty()) {
            return Arrays.asList(colNames.split(","));
        }
        return new ArrayList<String>();
    }

    public static List<String> getIOColumnTypes(Configuration conf) {
        String colTypes = conf.get("columns.types", "");
        if (colTypes != null && !colTypes.isEmpty()) {
            return TypeInfoUtils.getTypeInfosFromTypeString((String)colTypes).stream().map(t -> t.getTypeName()).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public static List<Pair<String, String>> getIOColumnNameAndTypes(Configuration conf) {
        List<String> names = HoodieColumnProjectionUtils.getIOColumns(conf);
        List<String> types = HoodieColumnProjectionUtils.getIOColumnTypes(conf);
        ValidationUtils.checkArgument((names.size() == types.size() ? 1 : 0) != 0);
        return IntStream.range(0, names.size()).mapToObj(idx -> Pair.of(names.get(idx), types.get(idx))).collect(Collectors.toList());
    }
}

