/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.NamespaceExistsException;
import org.apache.accumulo.core.client.NamespaceNotEmptyException;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.ClientExec;
import org.apache.accumulo.core.client.impl.ClientExecReturn;
import org.apache.accumulo.core.client.impl.Credentials;
import org.apache.accumulo.core.client.impl.MasterClient;
import org.apache.accumulo.core.client.impl.NamespaceOperationsHelper;
import org.apache.accumulo.core.client.impl.Namespaces;
import org.apache.accumulo.core.client.impl.ServerClient;
import org.apache.accumulo.core.client.impl.TableOperationsImpl;
import org.apache.accumulo.core.client.impl.thrift.ClientService;
import org.apache.accumulo.core.client.impl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.constraints.Constraint;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.master.thrift.FateOperation;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.trace.Tracer;
import org.apache.accumulo.core.util.OpTimer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class NamespaceOperationsImpl
extends NamespaceOperationsHelper {
    private final ClientContext context;
    private TableOperationsImpl tableOps;
    private static final Logger log = Logger.getLogger(TableOperations.class);

    public NamespaceOperationsImpl(ClientContext context, TableOperationsImpl tableOps) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context is null");
        this.context = context;
        this.tableOps = tableOps;
    }

    @Override
    public SortedSet<String> list() {
        OpTimer opTimer = new OpTimer(log, Level.TRACE).start("Fetching list of namespaces...");
        TreeSet<String> namespaces = new TreeSet<String>(Namespaces.getNameToIdMap(this.context.getInstance()).keySet());
        opTimer.stop("Fetched " + namespaces.size() + " namespaces in %DURATION%");
        return namespaces;
    }

    @Override
    public boolean exists(String namespace) {
        Preconditions.checkArgument((namespace != null ? 1 : 0) != 0, (Object)"namespace is null");
        OpTimer opTimer = new OpTimer(log, Level.TRACE).start("Checking if namespace " + namespace + " exists...");
        boolean exists = Namespaces.getNameToIdMap(this.context.getInstance()).containsKey(namespace);
        opTimer.stop("Checked existance of " + exists + " in %DURATION%");
        return exists;
    }

    @Override
    public void create(String namespace) throws AccumuloException, AccumuloSecurityException, NamespaceExistsException {
        Preconditions.checkArgument((namespace != null ? 1 : 0) != 0, (Object)"namespace is null");
        try {
            this.doNamespaceFateOperation(FateOperation.NAMESPACE_CREATE, Arrays.asList(ByteBuffer.wrap(namespace.getBytes(StandardCharsets.UTF_8))), Collections.emptyMap(), namespace);
        }
        catch (NamespaceNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void delete(String namespace) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException, NamespaceNotEmptyException {
        Preconditions.checkArgument((namespace != null ? 1 : 0) != 0, (Object)"namespace is null");
        String namespaceId = Namespaces.getNamespaceId(this.context.getInstance(), namespace);
        if (namespaceId.equals("+accumulo") || namespaceId.equals("+default")) {
            Credentials credentials = this.context.getCredentials();
            log.debug((Object)(credentials.getPrincipal() + " attempted to delete the " + namespaceId + " namespace"));
            throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.UNSUPPORTED_OPERATION);
        }
        if (Namespaces.getTableIds(this.context.getInstance(), namespaceId).size() > 0) {
            throw new NamespaceNotEmptyException(namespaceId, namespace, null);
        }
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(namespace.getBytes(StandardCharsets.UTF_8)));
        HashMap<String, String> opts = new HashMap<String, String>();
        try {
            this.doNamespaceFateOperation(FateOperation.NAMESPACE_DELETE, args, opts, namespace);
        }
        catch (NamespaceExistsException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void rename(String oldNamespaceName, String newNamespaceName) throws AccumuloSecurityException, NamespaceNotFoundException, AccumuloException, NamespaceExistsException {
        List<ByteBuffer> args = Arrays.asList(ByteBuffer.wrap(oldNamespaceName.getBytes(StandardCharsets.UTF_8)), ByteBuffer.wrap(newNamespaceName.getBytes(StandardCharsets.UTF_8)));
        HashMap<String, String> opts = new HashMap<String, String>();
        this.doNamespaceFateOperation(FateOperation.NAMESPACE_RENAME, args, opts, oldNamespaceName);
    }

    @Override
    public void setProperty(final String namespace, final String property, final String value) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException {
        Preconditions.checkArgument((namespace != null ? 1 : 0) != 0, (Object)"namespace is null");
        Preconditions.checkArgument((property != null ? 1 : 0) != 0, (Object)"property is null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"value is null");
        MasterClient.executeNamespace(this.context, new ClientExec<MasterClientService.Client>(){

            @Override
            public void execute(MasterClientService.Client client) throws Exception {
                client.setNamespaceProperty(Tracer.traceInfo(), NamespaceOperationsImpl.this.context.rpcCreds(), namespace, property, value);
            }
        });
    }

    @Override
    public void removeProperty(final String namespace, final String property) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException {
        Preconditions.checkArgument((namespace != null ? 1 : 0) != 0, (Object)"namespace is null");
        Preconditions.checkArgument((property != null ? 1 : 0) != 0, (Object)"property is null");
        MasterClient.executeNamespace(this.context, new ClientExec<MasterClientService.Client>(){

            @Override
            public void execute(MasterClientService.Client client) throws Exception {
                client.removeNamespaceProperty(Tracer.traceInfo(), NamespaceOperationsImpl.this.context.rpcCreds(), namespace, property);
            }
        });
    }

    @Override
    public Iterable<Map.Entry<String, String>> getProperties(final String namespace) throws AccumuloException, NamespaceNotFoundException {
        Preconditions.checkArgument((namespace != null ? 1 : 0) != 0, (Object)"namespace is null");
        try {
            return ServerClient.executeRaw(this.context, new ClientExecReturn<Map<String, String>, ClientService.Client>(){

                @Override
                public Map<String, String> execute(ClientService.Client client) throws Exception {
                    return client.getNamespaceConfiguration(Tracer.traceInfo(), NamespaceOperationsImpl.this.context.rpcCreds(), namespace);
                }
            }).entrySet();
        }
        catch (ThriftTableOperationException e) {
            switch (e.getType()) {
                case NAMESPACE_NOTFOUND: {
                    throw new NamespaceNotFoundException(e);
                }
            }
            throw new AccumuloException(e.description, (Throwable)((Object)e));
        }
        catch (AccumuloException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AccumuloException(e);
        }
    }

    @Override
    public Map<String, String> namespaceIdMap() {
        return Namespaces.getNameToIdMap(this.context.getInstance());
    }

    @Override
    public boolean testClassLoad(final String namespace, final String className, final String asTypeName) throws NamespaceNotFoundException, AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((namespace != null ? 1 : 0) != 0, (Object)"namespace is null");
        Preconditions.checkArgument((className != null ? 1 : 0) != 0, (Object)"className is null");
        Preconditions.checkArgument((asTypeName != null ? 1 : 0) != 0, (Object)"asTypeName is null");
        try {
            return ServerClient.executeRaw(this.context, new ClientExecReturn<Boolean, ClientService.Client>(){

                @Override
                public Boolean execute(ClientService.Client client) throws Exception {
                    return client.checkNamespaceClass(Tracer.traceInfo(), NamespaceOperationsImpl.this.context.rpcCreds(), namespace, className, asTypeName);
                }
            });
        }
        catch (ThriftTableOperationException e) {
            switch (e.getType()) {
                case NAMESPACE_NOTFOUND: {
                    throw new NamespaceNotFoundException(e);
                }
            }
            throw new AccumuloException(e.description, (Throwable)((Object)e));
        }
        catch (ThriftSecurityException e) {
            throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
        }
        catch (AccumuloException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AccumuloException(e);
        }
    }

    @Override
    public void attachIterator(String namespace, IteratorSetting setting, EnumSet<IteratorUtil.IteratorScope> scopes) throws AccumuloSecurityException, AccumuloException, NamespaceNotFoundException {
        this.testClassLoad(namespace, setting.getIteratorClass(), SortedKeyValueIterator.class.getName());
        super.attachIterator(namespace, setting, scopes);
    }

    @Override
    public int addConstraint(String namespace, String constraintClassName) throws AccumuloException, AccumuloSecurityException, NamespaceNotFoundException {
        this.testClassLoad(namespace, constraintClassName, Constraint.class.getName());
        return super.addConstraint(namespace, constraintClassName);
    }

    private String doNamespaceFateOperation(FateOperation op, List<ByteBuffer> args, Map<String, String> opts, String namespace) throws AccumuloSecurityException, AccumuloException, NamespaceExistsException, NamespaceNotFoundException {
        try {
            return this.tableOps.doFateOperation(op, args, opts, namespace);
        }
        catch (TableExistsException e) {
            throw new AssertionError((Object)e);
        }
        catch (TableNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }
}

