/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.blockfile.cache;

import java.util.Objects;
import org.apache.accumulo.core.file.blockfile.cache.CacheEntry;
import org.apache.accumulo.core.file.blockfile.cache.ClassSize;
import org.apache.accumulo.core.file.blockfile.cache.HeapSize;

public class CachedBlock
implements HeapSize,
Comparable<CachedBlock>,
CacheEntry {
    public static final long PER_BLOCK_OVERHEAD = ClassSize.align(ClassSize.OBJECT + 3 * ClassSize.REFERENCE + 16 + ClassSize.STRING + ClassSize.BYTE_BUFFER);
    private final String blockName;
    private final byte[] buf;
    private volatile long accessTime;
    private long size;
    private BlockPriority priority;
    private Object index;

    public CachedBlock(String blockName, byte[] buf, long accessTime, boolean inMemory) {
        this.blockName = blockName;
        this.buf = buf;
        this.accessTime = accessTime;
        this.size = (long)(ClassSize.align(blockName.length()) + ClassSize.align(buf.length)) + PER_BLOCK_OVERHEAD;
        this.priority = inMemory ? BlockPriority.MEMORY : BlockPriority.SINGLE;
    }

    public void access(long accessTime) {
        this.accessTime = accessTime;
        if (this.priority == BlockPriority.SINGLE) {
            this.priority = BlockPriority.MULTI;
        }
    }

    @Override
    public long heapSize() {
        return this.size;
    }

    public int hashCode() {
        return Objects.hashCode(this.accessTime);
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof CachedBlock && 0 == this.compareTo((CachedBlock)obj);
    }

    @Override
    public int compareTo(CachedBlock that) {
        if (this.accessTime == that.accessTime) {
            return 0;
        }
        return this.accessTime < that.accessTime ? 1 : -1;
    }

    @Override
    public byte[] getBuffer() {
        return this.buf;
    }

    public String getName() {
        return this.blockName;
    }

    public BlockPriority getPriority() {
        return this.priority;
    }

    @Override
    public Object getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(Object idx) {
        this.index = idx;
    }

    static enum BlockPriority {
        SINGLE,
        MULTI,
        MEMORY;

    }
}

