/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.nio.charset.StandardCharsets;

public class FastFormat {
    public static byte[] toZeroPaddedString(long num, int width, int radix, byte[] prefix) {
        byte[] ret = new byte[width + prefix.length];
        if (FastFormat.toZeroPaddedString(ret, 0, num, width, radix, prefix) != ret.length) {
            throw new RuntimeException(" Did not format to expected width " + num + " " + width + " " + radix + " " + new String(prefix, StandardCharsets.UTF_8));
        }
        return ret;
    }

    public static int toZeroPaddedString(byte[] output, int outputOffset, long num, int width, int radix, byte[] prefix) {
        if (num < 0L) {
            throw new IllegalArgumentException();
        }
        String s = Long.toString(num, radix);
        int index = outputOffset;
        for (int i = 0; i < prefix.length; ++i) {
            output[index++] = prefix[i];
        }
        int end = width - s.length() + index;
        while (index < end) {
            output[index++] = 48;
        }
        for (int i = 0; i < s.length(); ++i) {
            output[index++] = (byte)s.charAt(i);
        }
        return index - outputOffset;
    }
}

