/*
 * Decompiled with CFR 0.152.
 */
package coral.shading.io.trino.sql.tree;

import coral.shading.com.google.common.base.MoreObjects;
import coral.shading.com.google.common.collect.ImmutableList;
import coral.shading.io.trino.sql.tree.AstVisitor;
import coral.shading.io.trino.sql.tree.Node;
import coral.shading.io.trino.sql.tree.NodeLocation;
import coral.shading.io.trino.sql.tree.QualifiedName;
import coral.shading.io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class Comment
extends Statement {
    private final Type type;
    private final QualifiedName name;
    private final Optional<String> comment;

    public Comment(Type type, QualifiedName name, Optional<String> comment) {
        this(Optional.empty(), type, name, comment);
    }

    public Comment(NodeLocation location, Type type, QualifiedName name, Optional<String> comment) {
        this(Optional.of(location), type, name, comment);
    }

    private Comment(Optional<NodeLocation> location, Type type, QualifiedName name, Optional<String> comment) {
        super(location);
        this.type = Objects.requireNonNull(type, "type is null");
        this.name = Objects.requireNonNull(name, "name is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    public Type getType() {
        return this.type;
    }

    public QualifiedName getName() {
        return this.name;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitComment(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name, this.comment});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Comment o = (Comment)obj;
        return this.type == o.type && Objects.equals(this.name, o.name) && Objects.equals(this.comment, o.comment);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("type", (Object)this.type).add("name", this.name).add("comment", this.comment).toString();
    }

    public static enum Type {
        TABLE,
        COLUMN;

    }
}

