/*
 * Decompiled with CFR 0.152.
 */
package coral.shading.io.trino.sql.tree;

import coral.shading.com.google.common.base.Preconditions;
import coral.shading.com.google.common.collect.ImmutableList;
import coral.shading.io.trino.sql.tree.AstVisitor;
import coral.shading.io.trino.sql.tree.DereferenceExpression;
import coral.shading.io.trino.sql.tree.Expression;
import coral.shading.io.trino.sql.tree.Node;
import coral.shading.io.trino.sql.tree.NodeLocation;
import coral.shading.io.trino.sql.tree.QualifiedName;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class GroupingOperation
extends Expression {
    private final List<Expression> groupingColumns;

    public GroupingOperation(Optional<NodeLocation> location, List<QualifiedName> groupingColumns) {
        super(location);
        Objects.requireNonNull(groupingColumns);
        Preconditions.checkArgument(!groupingColumns.isEmpty(), "grouping operation columns cannot be empty");
        this.groupingColumns = groupingColumns.stream().map(DereferenceExpression::from).collect(ImmutableList.toImmutableList());
    }

    public List<Expression> getGroupingColumns() {
        return this.groupingColumns;
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitGroupingOperation(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.groupingColumns;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupingOperation other = (GroupingOperation)o;
        return Objects.equals(this.groupingColumns, other.groupingColumns);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.groupingColumns);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return GroupingOperation.sameClass(this, other);
    }
}

