/*
 * Decompiled with CFR 0.152.
 */
package coral.shading.io.trino.sql.util;

import coral.shading.com.google.common.collect.Streams;
import coral.shading.com.google.common.graph.Traverser;
import coral.shading.io.trino.sql.tree.Node;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;

public final class AstUtils {
    public static Stream<Node> preOrder(Node node) {
        return Streams.stream(Traverser.forTree(Node::getChildren).depthFirstPreOrder(Objects.requireNonNull(node, "node is null")));
    }

    public static boolean treeEqual(Node left, Node right, BiFunction<Node, Node, Boolean> subtreeComparator) {
        Boolean equal = subtreeComparator.apply(left, right);
        if (equal != null) {
            return equal;
        }
        List<? extends Node> leftChildren = left.getChildren();
        List<? extends Node> rightChildren = right.getChildren();
        if (leftChildren.size() != rightChildren.size()) {
            return false;
        }
        for (int i = 0; i < leftChildren.size(); ++i) {
            if (AstUtils.treeEqual(leftChildren.get(i), rightChildren.get(i), subtreeComparator)) continue;
            return false;
        }
        return true;
    }

    public static int treeHash(Node node, Function<Node, OptionalInt> subtreeHasher) {
        OptionalInt hash = subtreeHasher.apply(node);
        if (hash.isPresent()) {
            return hash.getAsInt();
        }
        List<? extends Node> children = node.getChildren();
        int result = node.getClass().hashCode();
        for (Node node2 : children) {
            result = 31 * result + AstUtils.treeHash(node2, subtreeHasher);
        }
        return result;
    }

    private AstUtils() {
    }
}

