/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import io.trino.orc.OrcCorruptionException;
import io.trino.orc.OrcDataSourceId;
import io.trino.orc.StreamId;
import io.trino.orc.ValidationHash;
import io.trino.orc.metadata.ColumnMetadata;
import io.trino.orc.metadata.CompressionKind;
import io.trino.orc.metadata.OrcColumnId;
import io.trino.orc.metadata.OrcMetadataReader;
import io.trino.orc.metadata.OrcType;
import io.trino.orc.metadata.PostScript;
import io.trino.orc.metadata.RowGroupIndex;
import io.trino.orc.metadata.StripeInformation;
import io.trino.orc.metadata.statistics.BinaryStatisticsBuilder;
import io.trino.orc.metadata.statistics.BooleanStatisticsBuilder;
import io.trino.orc.metadata.statistics.ColumnStatistics;
import io.trino.orc.metadata.statistics.DateStatisticsBuilder;
import io.trino.orc.metadata.statistics.DoubleStatisticsBuilder;
import io.trino.orc.metadata.statistics.IntegerStatistics;
import io.trino.orc.metadata.statistics.IntegerStatisticsBuilder;
import io.trino.orc.metadata.statistics.LongDecimalStatisticsBuilder;
import io.trino.orc.metadata.statistics.NoOpBloomFilterBuilder;
import io.trino.orc.metadata.statistics.ShortDecimalStatisticsBuilder;
import io.trino.orc.metadata.statistics.StatisticsBuilder;
import io.trino.orc.metadata.statistics.StatisticsHasher;
import io.trino.orc.metadata.statistics.StringStatistics;
import io.trino.orc.metadata.statistics.StringStatisticsBuilder;
import io.trino.orc.metadata.statistics.StripeStatistics;
import io.trino.orc.metadata.statistics.TimestampStatisticsBuilder;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.ColumnarArray;
import io.trino.spi.block.ColumnarMap;
import io.trino.spi.block.ColumnarRow;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.openjdk.jol.info.ClassLayout;

public class OrcWriteValidation {
    private final List<Integer> version;
    private final CompressionKind compression;
    private final ZoneId timeZone;
    private final int rowGroupMaxRowCount;
    private final List<String> columnNames;
    private final Map<String, Slice> metadata;
    private final WriteChecksum checksum;
    private final Map<Long, List<RowGroupStatistics>> rowGroupStatistics;
    private final Map<Long, StripeStatistics> stripeStatistics;
    private final Optional<ColumnMetadata<ColumnStatistics>> fileStatistics;
    private final int stringStatisticsLimitInBytes;

    private OrcWriteValidation(List<Integer> version, CompressionKind compression, ZoneId timeZone, int rowGroupMaxRowCount, List<String> columnNames, Map<String, Slice> metadata, WriteChecksum checksum, Map<Long, List<RowGroupStatistics>> rowGroupStatistics, Map<Long, StripeStatistics> stripeStatistics, Optional<ColumnMetadata<ColumnStatistics>> fileStatistics, int stringStatisticsLimitInBytes) {
        this.version = version;
        this.compression = compression;
        this.timeZone = timeZone;
        this.rowGroupMaxRowCount = rowGroupMaxRowCount;
        this.columnNames = columnNames;
        this.metadata = metadata;
        this.checksum = checksum;
        this.rowGroupStatistics = rowGroupStatistics;
        this.stripeStatistics = stripeStatistics;
        this.fileStatistics = fileStatistics;
        this.stringStatisticsLimitInBytes = stringStatisticsLimitInBytes;
    }

    public List<Integer> getVersion() {
        return this.version;
    }

    public CompressionKind getCompression() {
        return this.compression;
    }

    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    public void validateTimeZone(OrcDataSourceId orcDataSourceId, ZoneId actualTimeZone) throws OrcCorruptionException {
        if (!this.timeZone.equals(actualTimeZone)) {
            throw new OrcCorruptionException(orcDataSourceId, "Unexpected time zone");
        }
    }

    public int getRowGroupMaxRowCount() {
        return this.rowGroupMaxRowCount;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public Map<String, Slice> getMetadata() {
        return this.metadata;
    }

    public void validateMetadata(OrcDataSourceId orcDataSourceId, Map<String, Slice> actualMetadata) throws OrcCorruptionException {
        if (!this.metadata.equals(actualMetadata)) {
            throw new OrcCorruptionException(orcDataSourceId, "Unexpected metadata");
        }
    }

    public WriteChecksum getChecksum() {
        return this.checksum;
    }

    public void validateFileStatistics(OrcDataSourceId orcDataSourceId, Optional<ColumnMetadata<ColumnStatistics>> actualFileStatistics) throws OrcCorruptionException {
        if (this.fileStatistics.isEmpty()) {
            if (actualFileStatistics.isPresent()) {
                throw new OrcCorruptionException(orcDataSourceId, "Write validation failed: unexpected file statistics");
            }
            return;
        }
        if (actualFileStatistics.isEmpty()) {
            throw new OrcCorruptionException(orcDataSourceId, "Write validation failed: expected file statistics");
        }
        OrcWriteValidation.validateColumnStatisticsEquivalent(orcDataSourceId, "file", actualFileStatistics.get(), this.fileStatistics.get());
    }

    public void validateStripeStatistics(OrcDataSourceId orcDataSourceId, List<StripeInformation> actualStripes, List<Optional<StripeStatistics>> actualStripeStatistics) throws OrcCorruptionException {
        Objects.requireNonNull(actualStripes, "actualStripes is null");
        Objects.requireNonNull(actualStripeStatistics, "actualStripeStatistics is null");
        if (actualStripeStatistics.size() != this.stripeStatistics.size()) {
            throw new OrcCorruptionException(orcDataSourceId, "Write validation failed: unexpected number of columns in stripe statistics");
        }
        for (int stripeIndex = 0; stripeIndex < actualStripes.size(); ++stripeIndex) {
            long stripeOffset = actualStripes.get(stripeIndex).getOffset();
            StripeStatistics actual = actualStripeStatistics.get(stripeIndex).get();
            this.validateStripeStatistics(orcDataSourceId, stripeOffset, actual.getColumnStatistics());
        }
    }

    public void validateStripeStatistics(OrcDataSourceId orcDataSourceId, long stripeOffset, ColumnMetadata<ColumnStatistics> actual) throws OrcCorruptionException {
        StripeStatistics expected = this.stripeStatistics.get(stripeOffset);
        if (expected == null) {
            throw new OrcCorruptionException(orcDataSourceId, "Unexpected stripe at offset %s", stripeOffset);
        }
        OrcWriteValidation.validateColumnStatisticsEquivalent(orcDataSourceId, "Stripe at " + stripeOffset, actual, expected.getColumnStatistics());
    }

    public void validateRowGroupStatistics(OrcDataSourceId orcDataSourceId, long stripeOffset, Map<StreamId, List<RowGroupIndex>> actualRowGroupStatistics) throws OrcCorruptionException {
        Objects.requireNonNull(actualRowGroupStatistics, "actualRowGroupStatistics is null");
        List<RowGroupStatistics> expectedRowGroupStatistics = this.rowGroupStatistics.get(stripeOffset);
        if (expectedRowGroupStatistics == null) {
            throw new OrcCorruptionException(orcDataSourceId, "Unexpected stripe at offset %s", stripeOffset);
        }
        int rowGroupCount = expectedRowGroupStatistics.size();
        for (Map.Entry<StreamId, List<RowGroupIndex>> entry : actualRowGroupStatistics.entrySet()) {
            if (entry.getValue().size() == rowGroupCount) continue;
            throw new OrcCorruptionException(orcDataSourceId, "Unexpected row group count stripe in at offset %s", stripeOffset);
        }
        for (int rowGroupIndex = 0; rowGroupIndex < expectedRowGroupStatistics.size(); ++rowGroupIndex) {
            RowGroupStatistics expectedRowGroup = expectedRowGroupStatistics.get(rowGroupIndex);
            if (expectedRowGroup.getValidationMode() != OrcWriteValidationMode.HASHED) {
                Map<OrcColumnId, ColumnStatistics> expectedStatistics = expectedRowGroup.getColumnStatistics();
                Set actualColumns = actualRowGroupStatistics.keySet().stream().map(StreamId::getColumnId).collect(Collectors.toSet());
                if (!expectedStatistics.keySet().equals(actualColumns)) {
                    throw new OrcCorruptionException(orcDataSourceId, "Unexpected column in row group %s in stripe at offset %s", rowGroupIndex, stripeOffset);
                }
                for (Map.Entry<StreamId, List<RowGroupIndex>> entry : actualRowGroupStatistics.entrySet()) {
                    ColumnStatistics actual = entry.getValue().get(rowGroupIndex).getColumnStatistics();
                    ColumnStatistics expected = expectedStatistics.get(entry.getKey().getColumnId());
                    OrcWriteValidation.validateColumnStatisticsEquivalent(orcDataSourceId, "Row group " + rowGroupIndex + " in stripe at offset " + stripeOffset, actual, expected);
                }
            }
            if (expectedRowGroup.getValidationMode() == OrcWriteValidationMode.DETAILED) continue;
            RowGroupStatistics actualRowGroup = OrcWriteValidation.buildActualRowGroupStatistics(rowGroupIndex, actualRowGroupStatistics);
            if (expectedRowGroup.getHash() == actualRowGroup.getHash()) continue;
            throw new OrcCorruptionException(orcDataSourceId, "Checksum mismatch for row group %s in stripe at offset %s", rowGroupIndex, stripeOffset);
        }
    }

    private static RowGroupStatistics buildActualRowGroupStatistics(int rowGroupIndex, Map<StreamId, List<RowGroupIndex>> actualRowGroupStatistics) {
        return new RowGroupStatistics(OrcWriteValidationMode.BOTH, actualRowGroupStatistics.entrySet().stream().collect(Collectors.toMap(entry -> ((StreamId)entry.getKey()).getColumnId(), entry -> ((RowGroupIndex)((List)entry.getValue()).get(rowGroupIndex)).getColumnStatistics())));
    }

    public void validateRowGroupStatistics(OrcDataSourceId orcDataSourceId, long stripeOffset, int rowGroupIndex, ColumnMetadata<ColumnStatistics> actual) throws OrcCorruptionException {
        List<RowGroupStatistics> rowGroups = this.rowGroupStatistics.get(stripeOffset);
        if (rowGroups == null) {
            throw new OrcCorruptionException(orcDataSourceId, "Unexpected stripe at offset %s", stripeOffset);
        }
        if (rowGroups.size() <= rowGroupIndex) {
            throw new OrcCorruptionException(orcDataSourceId, "Unexpected row group %s in stripe at offset %s", rowGroupIndex, stripeOffset);
        }
        RowGroupStatistics expectedRowGroup = rowGroups.get(rowGroupIndex);
        RowGroupStatistics actualRowGroup = new RowGroupStatistics(OrcWriteValidationMode.BOTH, (Map)IntStream.range(1, actual.size()).mapToObj(OrcColumnId::new).collect(ImmutableMap.toImmutableMap(Function.identity(), actual::get)));
        if (expectedRowGroup.getValidationMode() != OrcWriteValidationMode.HASHED) {
            Map<OrcColumnId, ColumnStatistics> expectedByColumnIndex = expectedRowGroup.getColumnStatistics();
            ColumnMetadata<ColumnStatistics> expected = new ColumnMetadata<ColumnStatistics>((List)IntStream.range(1, actual.size()).mapToObj(OrcColumnId::new).map(expectedByColumnIndex::get).collect(ImmutableList.toImmutableList()));
            actual = new ColumnMetadata((List)actual.stream().skip(1L).collect(ImmutableList.toImmutableList()));
            OrcWriteValidation.validateColumnStatisticsEquivalent(orcDataSourceId, "Row group " + rowGroupIndex + " in stripe at offset " + stripeOffset, actual, expected);
        }
        if (expectedRowGroup.getValidationMode() != OrcWriteValidationMode.DETAILED && expectedRowGroup.getHash() != actualRowGroup.getHash()) {
            throw new OrcCorruptionException(orcDataSourceId, "Checksum mismatch for row group %s in stripe at offset %s", rowGroupIndex, stripeOffset);
        }
    }

    public StatisticsValidation createWriteStatisticsBuilder(ColumnMetadata<OrcType> orcTypes, List<Type> readTypes) {
        Preconditions.checkArgument((readTypes.size() == orcTypes.get(OrcColumnId.ROOT_COLUMN).getFieldCount() ? 1 : 0) != 0, (Object)"statistics validation requires all columns to be read");
        return new StatisticsValidation(readTypes);
    }

    private static void validateColumnStatisticsEquivalent(OrcDataSourceId orcDataSourceId, String name, ColumnMetadata<ColumnStatistics> actualColumnStatistics, ColumnMetadata<ColumnStatistics> expectedColumnStatistics) throws OrcCorruptionException {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(actualColumnStatistics, "actualColumnStatistics is null");
        Objects.requireNonNull(expectedColumnStatistics, "expectedColumnStatistics is null");
        if (actualColumnStatistics.size() != expectedColumnStatistics.size()) {
            throw new OrcCorruptionException(orcDataSourceId, "Write validation failed: unexpected number of columns in %s statistics", name);
        }
        for (int i = 0; i < actualColumnStatistics.size(); ++i) {
            OrcColumnId columnId = new OrcColumnId(i);
            ColumnStatistics actual = actualColumnStatistics.get(columnId);
            ColumnStatistics expected = expectedColumnStatistics.get(columnId);
            OrcWriteValidation.validateColumnStatisticsEquivalent(orcDataSourceId, name + " column " + i, actual, expected);
        }
    }

    private static void validateColumnStatisticsEquivalent(OrcDataSourceId orcDataSourceId, String name, ColumnStatistics actualColumnStatistics, ColumnStatistics expectedColumnStatistics) throws OrcCorruptionException {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(actualColumnStatistics, "actualColumnStatistics is null");
        Objects.requireNonNull(expectedColumnStatistics, "expectedColumnStatistics is null");
        if (actualColumnStatistics.getNumberOfValues() != expectedColumnStatistics.getNumberOfValues()) {
            throw new OrcCorruptionException(orcDataSourceId, "Write validation failed: unexpected number of values in %s statistics", name);
        }
        if (!Objects.equals(actualColumnStatistics.getBooleanStatistics(), expectedColumnStatistics.getBooleanStatistics())) {
            throw new OrcCorruptionException(orcDataSourceId, "Write validation failed: unexpected boolean counts in %s statistics", name);
        }
        if (!Objects.equals(actualColumnStatistics.getIntegerStatistics(), expectedColumnStatistics.getIntegerStatistics())) {
            IntegerStatistics actualIntegerStatistics = actualColumnStatistics.getIntegerStatistics();
            IntegerStatistics expectedIntegerStatistics = expectedColumnStatistics.getIntegerStatistics();
            if (actualIntegerStatistics == null || expectedIntegerStatistics == null || !Objects.equals(actualIntegerStatistics.getMin(), expectedIntegerStatistics.getMin()) || !Objects.equals(actualIntegerStatistics.getMax(), expectedIntegerStatistics.getMax()) || actualIntegerStatistics.getSum() != null && expectedIntegerStatistics.getSum() != null && !Objects.equals(actualIntegerStatistics.getSum(), expectedIntegerStatistics.getSum())) {
                throw new OrcCorruptionException(orcDataSourceId, "Write validation failed: unexpected integer range in %s statistics", name);
            }
        }
        if (!Objects.equals(actualColumnStatistics.getDoubleStatistics(), expectedColumnStatistics.getDoubleStatistics())) {
            throw new OrcCorruptionException(orcDataSourceId, "Write validation failed: unexpected double range in %s statistics", name);
        }
        StringStatistics expectedStringStatistics = expectedColumnStatistics.getStringStatistics();
        if (expectedStringStatistics != null) {
            expectedStringStatistics = new StringStatistics(OrcMetadataReader.minStringTruncateToValidRange(expectedStringStatistics.getMin(), PostScript.HiveWriterVersion.ORC_HIVE_8732), OrcMetadataReader.maxStringTruncateToValidRange(expectedStringStatistics.getMax(), PostScript.HiveWriterVersion.ORC_HIVE_8732), expectedStringStatistics.getSum());
        }
        StringStatistics actualStringStatistics = actualColumnStatistics.getStringStatistics();
        if (!Objects.equals(actualColumnStatistics.getStringStatistics(), expectedStringStatistics) && expectedStringStatistics != null && (actualStringStatistics == null || actualStringStatistics.getSum() != expectedStringStatistics.getSum() || expectedStringStatistics.getMax() != null && !Objects.equals(actualStringStatistics.getMax(), expectedStringStatistics.getMax()) || expectedStringStatistics.getMin() != null && !Objects.equals(actualStringStatistics.getMin(), expectedStringStatistics.getMin()))) {
            throw new OrcCorruptionException(orcDataSourceId, "Write validation failed: unexpected string range in %s statistics", name);
        }
        if (!Objects.equals(actualColumnStatistics.getDateStatistics(), expectedColumnStatistics.getDateStatistics())) {
            throw new OrcCorruptionException(orcDataSourceId, "Write validation failed: unexpected date range in %s statistics", name);
        }
        if (!Objects.equals(actualColumnStatistics.getDecimalStatistics(), expectedColumnStatistics.getDecimalStatistics())) {
            throw new OrcCorruptionException(orcDataSourceId, "Write validation failed: unexpected decimal range in %s statistics", name);
        }
        if (!Objects.equals(actualColumnStatistics.getBloomFilter(), expectedColumnStatistics.getBloomFilter())) {
            throw new OrcCorruptionException(orcDataSourceId, "Write validation failed: unexpected bloom filter in %s statistics", name);
        }
    }

    public static class WriteChecksum {
        private final long totalRowCount;
        private final long stripeHash;
        private final List<Long> columnHashes;

        public WriteChecksum(long totalRowCount, long stripeHash, List<Long> columnHashes) {
            this.totalRowCount = totalRowCount;
            this.stripeHash = stripeHash;
            this.columnHashes = columnHashes;
        }

        public long getTotalRowCount() {
            return this.totalRowCount;
        }

        public long getStripeHash() {
            return this.stripeHash;
        }

        public List<Long> getColumnHashes() {
            return this.columnHashes;
        }
    }

    private static class RowGroupStatistics {
        private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(RowGroupStatistics.class).instanceSize());
        private final OrcWriteValidationMode validationMode;
        private final SortedMap<OrcColumnId, ColumnStatistics> columnStatistics;
        private final long hash;

        public RowGroupStatistics(OrcWriteValidationMode validationMode, Map<OrcColumnId, ColumnStatistics> columnStatistics) {
            this.validationMode = validationMode;
            Objects.requireNonNull(columnStatistics, "columnStatistics is null");
            switch (validationMode) {
                case HASHED: {
                    this.columnStatistics = ImmutableSortedMap.of();
                    this.hash = RowGroupStatistics.hashColumnStatistics((SortedMap<OrcColumnId, ColumnStatistics>)ImmutableSortedMap.copyOf(columnStatistics));
                    break;
                }
                case DETAILED: {
                    this.columnStatistics = ImmutableSortedMap.copyOf(columnStatistics);
                    this.hash = 0L;
                    break;
                }
                case BOTH: {
                    this.columnStatistics = ImmutableSortedMap.copyOf(columnStatistics);
                    this.hash = RowGroupStatistics.hashColumnStatistics(this.columnStatistics);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported validation mode");
                }
            }
        }

        private static long hashColumnStatistics(SortedMap<OrcColumnId, ColumnStatistics> columnStatistics) {
            StatisticsHasher statisticsHasher = new StatisticsHasher();
            statisticsHasher.putInt(columnStatistics.size());
            for (Map.Entry<OrcColumnId, ColumnStatistics> entry : columnStatistics.entrySet()) {
                statisticsHasher.putInt(entry.getKey().getId()).putOptionalHashable(entry.getValue());
            }
            return statisticsHasher.hash();
        }

        public OrcWriteValidationMode getValidationMode() {
            return this.validationMode;
        }

        public Map<OrcColumnId, ColumnStatistics> getColumnStatistics() {
            Verify.verify((this.validationMode != OrcWriteValidationMode.HASHED ? 1 : 0) != 0, (String)"columnStatistics are not available in HASHED mode", (Object[])new Object[0]);
            return this.columnStatistics;
        }

        public long getHash() {
            return this.hash;
        }
    }

    public static enum OrcWriteValidationMode {
        HASHED,
        DETAILED,
        BOTH;

    }

    public class StatisticsValidation {
        private final List<Type> types;
        private List<ColumnStatisticsValidation> columnStatisticsValidations;
        private long rowCount;

        private StatisticsValidation(List<Type> types) {
            this.types = Objects.requireNonNull(types, "types is null");
            this.columnStatisticsValidations = (List)types.stream().map(x$0 -> new ColumnStatisticsValidation((Type)x$0)).collect(ImmutableList.toImmutableList());
        }

        public void reset() {
            this.rowCount = 0L;
            this.columnStatisticsValidations = (List)this.types.stream().map(x$0 -> new ColumnStatisticsValidation((Type)x$0)).collect(ImmutableList.toImmutableList());
        }

        public void addPage(Page page) {
            this.rowCount += (long)page.getPositionCount();
            for (int channel = 0; channel < this.columnStatisticsValidations.size(); ++channel) {
                this.columnStatisticsValidations.get(channel).addBlock(page.getBlock(channel));
            }
        }

        public Optional<ColumnMetadata<ColumnStatistics>> build() {
            if (this.rowCount == 0L) {
                return Optional.empty();
            }
            ImmutableList.Builder statisticsBuilders = ImmutableList.builder();
            statisticsBuilders.add((Object)new ColumnStatistics(this.rowCount, 0L, null, null, null, null, null, null, null, null, null, null));
            this.columnStatisticsValidations.forEach(validation -> validation.build((ImmutableList.Builder<ColumnStatistics>)statisticsBuilders));
            return Optional.of(new ColumnMetadata(statisticsBuilders.build()));
        }
    }

    public static class OrcWriteValidationBuilder {
        private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(OrcWriteValidationBuilder.class).instanceSize());
        private final OrcWriteValidationMode validationMode;
        private List<Integer> version;
        private CompressionKind compression;
        private ZoneId timeZone;
        private int rowGroupMaxRowCount;
        private int stringStatisticsLimitInBytes;
        private List<String> columnNames;
        private final Map<String, Slice> metadata = new HashMap<String, Slice>();
        private final WriteChecksumBuilder checksum;
        private List<RowGroupStatistics> currentRowGroupStatistics = new ArrayList<RowGroupStatistics>();
        private final Map<Long, List<RowGroupStatistics>> rowGroupStatisticsByStripe = new HashMap<Long, List<RowGroupStatistics>>();
        private final Map<Long, StripeStatistics> stripeStatistics = new HashMap<Long, StripeStatistics>();
        private Optional<ColumnMetadata<ColumnStatistics>> fileStatistics = Optional.empty();
        private long retainedSize = INSTANCE_SIZE;

        public OrcWriteValidationBuilder(OrcWriteValidationMode validationMode, List<Type> types) {
            this.validationMode = validationMode;
            this.checksum = new WriteChecksumBuilder(types);
        }

        public long getRetainedSize() {
            return this.retainedSize;
        }

        public OrcWriteValidationBuilder setVersion(List<Integer> version) {
            this.version = ImmutableList.copyOf(version);
            return this;
        }

        public void setCompression(CompressionKind compression) {
            this.compression = compression;
        }

        public void setTimeZone(ZoneId timeZone) {
            this.timeZone = timeZone;
        }

        public void setRowGroupMaxRowCount(int rowGroupMaxRowCount) {
            this.rowGroupMaxRowCount = rowGroupMaxRowCount;
        }

        public OrcWriteValidationBuilder setStringStatisticsLimitInBytes(int stringStatisticsLimitInBytes) {
            this.stringStatisticsLimitInBytes = stringStatisticsLimitInBytes;
            return this;
        }

        public OrcWriteValidationBuilder setColumnNames(List<String> columnNames) {
            this.columnNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnNames, "columnNames is null"));
            return this;
        }

        public OrcWriteValidationBuilder addMetadataProperty(String key, Slice value) {
            this.metadata.put(key, value);
            return this;
        }

        public OrcWriteValidationBuilder addStripe(int rowCount) {
            this.checksum.addStripe(rowCount);
            return this;
        }

        public OrcWriteValidationBuilder addPage(Page page) {
            this.checksum.addPage(page);
            return this;
        }

        public void addRowGroupStatistics(Map<OrcColumnId, ColumnStatistics> columnStatistics) {
            RowGroupStatistics rowGroupStatistics = new RowGroupStatistics(this.validationMode, columnStatistics);
            this.currentRowGroupStatistics.add(rowGroupStatistics);
            this.retainedSize += (long)RowGroupStatistics.INSTANCE_SIZE;
            if (this.validationMode != OrcWriteValidationMode.HASHED) {
                for (ColumnStatistics statistics : rowGroupStatistics.getColumnStatistics().values()) {
                    this.retainedSize += 4L + statistics.getRetainedSizeInBytes();
                }
            }
        }

        public void addStripeStatistics(long stripStartOffset, StripeStatistics columnStatistics) {
            this.stripeStatistics.put(stripStartOffset, columnStatistics);
            this.rowGroupStatisticsByStripe.put(stripStartOffset, this.currentRowGroupStatistics);
            this.currentRowGroupStatistics = new ArrayList<RowGroupStatistics>();
        }

        public void setFileStatistics(Optional<ColumnMetadata<ColumnStatistics>> fileStatistics) {
            this.fileStatistics = fileStatistics;
        }

        public OrcWriteValidation build() {
            return new OrcWriteValidation(this.version, this.compression, this.timeZone, this.rowGroupMaxRowCount, this.columnNames, this.metadata, this.checksum.build(), this.rowGroupStatisticsByStripe, this.stripeStatistics, this.fileStatistics, this.stringStatisticsLimitInBytes);
        }
    }

    private static class CountStatisticsBuilder
    implements StatisticsBuilder {
        private long rowCount;

        private CountStatisticsBuilder() {
        }

        @Override
        public void addBlock(Type type, Block block) {
            for (int position = 0; position < block.getPositionCount(); ++position) {
                if (block.isNull(position)) continue;
                ++this.rowCount;
            }
        }

        @Override
        public ColumnStatistics buildColumnStatistics() {
            return new ColumnStatistics(this.rowCount, 0L, null, null, null, null, null, null, null, null, null, null);
        }
    }

    private class ColumnStatisticsValidation {
        private final Type type;
        private final StatisticsBuilder statisticsBuilder;
        private final Function<Block, List<Block>> fieldExtractor;
        private final List<ColumnStatisticsValidation> fieldBuilders;

        private ColumnStatisticsValidation(Type type) {
            this.type = Objects.requireNonNull(type, "type is null");
            if (BooleanType.BOOLEAN.equals((Object)type)) {
                this.statisticsBuilder = new BooleanStatisticsBuilder();
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (TinyintType.TINYINT.equals((Object)type)) {
                this.statisticsBuilder = new CountStatisticsBuilder();
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (SmallintType.SMALLINT.equals((Object)type)) {
                this.statisticsBuilder = new IntegerStatisticsBuilder(new NoOpBloomFilterBuilder());
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (IntegerType.INTEGER.equals((Object)type)) {
                this.statisticsBuilder = new IntegerStatisticsBuilder(new NoOpBloomFilterBuilder());
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (BigintType.BIGINT.equals((Object)type)) {
                this.statisticsBuilder = new IntegerStatisticsBuilder(new NoOpBloomFilterBuilder());
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (DoubleType.DOUBLE.equals((Object)type)) {
                this.statisticsBuilder = new DoubleStatisticsBuilder(new NoOpBloomFilterBuilder());
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (RealType.REAL.equals((Object)type)) {
                this.statisticsBuilder = new DoubleStatisticsBuilder(new NoOpBloomFilterBuilder());
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (type instanceof VarcharType) {
                this.statisticsBuilder = new StringStatisticsBuilder(OrcWriteValidation.this.stringStatisticsLimitInBytes, new NoOpBloomFilterBuilder());
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (type instanceof CharType) {
                this.statisticsBuilder = new StringStatisticsBuilder(OrcWriteValidation.this.stringStatisticsLimitInBytes, new NoOpBloomFilterBuilder());
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (VarbinaryType.VARBINARY.equals((Object)type) || UuidType.UUID.equals((Object)type)) {
                this.statisticsBuilder = new BinaryStatisticsBuilder();
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (DateType.DATE.equals((Object)type)) {
                this.statisticsBuilder = new DateStatisticsBuilder(new NoOpBloomFilterBuilder());
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (TimestampType.TIMESTAMP_MILLIS.equals((Object)type) || TimestampType.TIMESTAMP_MICROS.equals((Object)type)) {
                this.statisticsBuilder = new TimestampStatisticsBuilder(this::timestampMicrosToMillis);
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (TimestampType.TIMESTAMP_NANOS.equals((Object)type)) {
                this.statisticsBuilder = new TimestampStatisticsBuilder(this::timestampNanosToMillis);
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS.equals((Object)type)) {
                this.statisticsBuilder = new TimestampStatisticsBuilder(this::timestampTzShortToMillis);
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS.equals((Object)type) || TimestampWithTimeZoneType.TIMESTAMP_TZ_NANOS.equals((Object)type)) {
                this.statisticsBuilder = new TimestampStatisticsBuilder(this::timestampTzLongToMillis);
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (type instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)type;
                this.statisticsBuilder = decimalType.isShort() ? new ShortDecimalStatisticsBuilder(decimalType.getScale()) : new LongDecimalStatisticsBuilder();
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (type instanceof ArrayType) {
                this.statisticsBuilder = new CountStatisticsBuilder();
                this.fieldExtractor = block -> ImmutableList.of((Object)ColumnarArray.toColumnarArray((Block)block).getElementsBlock());
                this.fieldBuilders = ImmutableList.of((Object)new ColumnStatisticsValidation((Type)Iterables.getOnlyElement((Iterable)type.getTypeParameters())));
            } else if (type instanceof MapType) {
                this.statisticsBuilder = new CountStatisticsBuilder();
                this.fieldExtractor = block -> {
                    ColumnarMap columnarMap = ColumnarMap.toColumnarMap((Block)block);
                    return ImmutableList.of((Object)columnarMap.getKeysBlock(), (Object)columnarMap.getValuesBlock());
                };
                this.fieldBuilders = (List)type.getTypeParameters().stream().map(x$0 -> new ColumnStatisticsValidation((Type)x$0)).collect(ImmutableList.toImmutableList());
            } else if (type instanceof RowType) {
                this.statisticsBuilder = new CountStatisticsBuilder();
                this.fieldExtractor = block -> {
                    ColumnarRow columnarRow = ColumnarRow.toColumnarRow((Block)block);
                    ImmutableList.Builder fields = ImmutableList.builder();
                    for (int index = 0; index < columnarRow.getFieldCount(); ++index) {
                        fields.add((Object)columnarRow.getField(index));
                    }
                    return fields.build();
                };
                this.fieldBuilders = (List)type.getTypeParameters().stream().map(x$0 -> new ColumnStatisticsValidation((Type)x$0)).collect(ImmutableList.toImmutableList());
            } else {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type: %s", type));
            }
        }

        private long timestampMicrosToMillis(Type blockType, Block block, int position) {
            return Math.floorDiv(blockType.getLong(block, position), 1000);
        }

        private long timestampNanosToMillis(Type blockType, Block block, int position) {
            return Math.floorDiv(((LongTimestamp)blockType.getObject(block, position)).getEpochMicros(), 1000);
        }

        private long timestampTzShortToMillis(Type blockType, Block block, int position) {
            return DateTimeEncoding.unpackMillisUtc((long)blockType.getLong(block, position));
        }

        private long timestampTzLongToMillis(Type blockType, Block block, int position) {
            return ((LongTimestampWithTimeZone)blockType.getObject(block, position)).getEpochMillis();
        }

        private void addBlock(Block block) {
            this.statisticsBuilder.addBlock(this.type, block);
            List<Block> fields = this.fieldExtractor.apply(block);
            for (int i = 0; i < this.fieldBuilders.size(); ++i) {
                this.fieldBuilders.get(i).addBlock(fields.get(i));
            }
        }

        private void build(ImmutableList.Builder<ColumnStatistics> output) {
            output.add((Object)this.statisticsBuilder.buildColumnStatistics());
            this.fieldBuilders.forEach(fieldBuilders -> fieldBuilders.build(output));
        }
    }

    public static class WriteChecksumBuilder {
        private final List<ValidationHash> validationHashes;
        private long totalRowCount;
        private final List<XxHash64> columnHashes;
        private final XxHash64 stripeHash = new XxHash64();
        private final byte[] longBuffer = new byte[8];
        private final Slice longSlice = Slices.wrappedBuffer((byte[])this.longBuffer);

        private WriteChecksumBuilder(List<Type> types) {
            this.validationHashes = (List)types.stream().map(ValidationHash::createValidationHash).collect(ImmutableList.toImmutableList());
            ImmutableList.Builder columnHashes = ImmutableList.builder();
            for (Type ignored : types) {
                columnHashes.add((Object)new XxHash64());
            }
            this.columnHashes = columnHashes.build();
        }

        public static WriteChecksumBuilder createWriteChecksumBuilder(ColumnMetadata<OrcType> orcTypes, List<Type> readTypes) {
            Preconditions.checkArgument((readTypes.size() == orcTypes.get(OrcColumnId.ROOT_COLUMN).getFieldCount() ? 1 : 0) != 0, (Object)"checksum requires all columns to be read");
            return new WriteChecksumBuilder(readTypes);
        }

        public void addStripe(int rowCount) {
            this.longSlice.setInt(0, rowCount);
            this.stripeHash.update(this.longBuffer, 0, 4);
        }

        public void addPage(Page page) {
            Objects.requireNonNull(page, "page is null");
            Preconditions.checkArgument((page.getChannelCount() == this.columnHashes.size() ? 1 : 0) != 0, (Object)"invalid page");
            for (int channel = 0; channel < this.columnHashes.size(); ++channel) {
                ValidationHash validationHash = this.validationHashes.get(channel);
                Block block = page.getBlock(channel);
                XxHash64 xxHash64 = this.columnHashes.get(channel);
                for (int position = 0; position < block.getPositionCount(); ++position) {
                    long hash = validationHash.hash(block, position);
                    this.longSlice.setLong(0, hash);
                    xxHash64.update(this.longBuffer);
                }
            }
            this.totalRowCount += (long)page.getPositionCount();
        }

        public WriteChecksum build() {
            return new WriteChecksum(this.totalRowCount, this.stripeHash.hash(), (List)this.columnHashes.stream().map(XxHash64::hash).collect(ImmutableList.toImmutableList()));
        }
    }
}

