/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.reader;

import com.google.common.base.Preconditions;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.orc.OrcBlockFactory;
import io.trino.orc.OrcColumn;
import io.trino.orc.OrcCorruptionException;
import io.trino.orc.OrcReader;
import io.trino.orc.metadata.OrcType;
import io.trino.orc.reader.BooleanColumnReader;
import io.trino.orc.reader.ByteColumnReader;
import io.trino.orc.reader.ColumnReader;
import io.trino.orc.reader.DecimalColumnReader;
import io.trino.orc.reader.DoubleColumnReader;
import io.trino.orc.reader.FloatColumnReader;
import io.trino.orc.reader.ListColumnReader;
import io.trino.orc.reader.LongColumnReader;
import io.trino.orc.reader.MapColumnReader;
import io.trino.orc.reader.ReaderUtils;
import io.trino.orc.reader.SliceColumnReader;
import io.trino.orc.reader.StructColumnReader;
import io.trino.orc.reader.TimeColumnReader;
import io.trino.orc.reader.TimestampColumnReader;
import io.trino.orc.reader.UnionColumnReader;
import io.trino.orc.reader.UuidColumnReader;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.Type;
import io.trino.spi.type.UuidType;

public final class ColumnReaders {
    public static final String ICEBERG_BINARY_TYPE = "iceberg.binary-type";

    private ColumnReaders() {
    }

    public static ColumnReader createColumnReader(Type type, OrcColumn column, OrcReader.ProjectedLayout projectedLayout, AggregatedMemoryContext memoryContext, OrcBlockFactory blockFactory, OrcReader.FieldMapperFactory fieldMapperFactory) throws OrcCorruptionException {
        if (type instanceof TimeType) {
            if (!type.equals(TimeType.TIME_MICROS) || column.getColumnType() != OrcType.OrcTypeKind.LONG || !"TIME".equals(column.getAttributes().get("iceberg.long-type"))) {
                throw ReaderUtils.invalidStreamType(column, type);
            }
            return new TimeColumnReader(type, column, memoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
        }
        if (type instanceof UuidType) {
            Preconditions.checkArgument((column.getColumnType() == OrcType.OrcTypeKind.BINARY ? 1 : 0) != 0, (Object)("UUID type can only be read from BINARY column but got " + column));
            Preconditions.checkArgument((boolean)"UUID".equals(column.getAttributes().get(ICEBERG_BINARY_TYPE)), (String)"Expected ORC column for UUID data to be annotated with %s=UUID: %s", (Object)ICEBERG_BINARY_TYPE, (Object)column);
            return new UuidColumnReader(column);
        }
        switch (column.getColumnType()) {
            case BOOLEAN: {
                return new BooleanColumnReader(type, column, memoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            }
            case BYTE: {
                if (type == IntegerType.INTEGER && !column.getAttributes().containsKey("iceberg.id")) {
                    throw ReaderUtils.invalidStreamType(column, type);
                }
                return new ByteColumnReader(type, column, memoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            }
            case SHORT: 
            case INT: 
            case LONG: 
            case DATE: {
                return new LongColumnReader(type, column, memoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            }
            case FLOAT: {
                return new FloatColumnReader(type, column, memoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            }
            case DOUBLE: {
                return new DoubleColumnReader(type, column, memoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            }
            case BINARY: 
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                return new SliceColumnReader(type, column, memoryContext);
            }
            case TIMESTAMP: 
            case TIMESTAMP_INSTANT: {
                return new TimestampColumnReader(type, column, memoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            }
            case LIST: {
                return new ListColumnReader(type, column, memoryContext, blockFactory, fieldMapperFactory);
            }
            case STRUCT: {
                return new StructColumnReader(type, column, projectedLayout, memoryContext, blockFactory, fieldMapperFactory);
            }
            case MAP: {
                return new MapColumnReader(type, column, memoryContext, blockFactory, fieldMapperFactory);
            }
            case DECIMAL: {
                return new DecimalColumnReader(type, column, memoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            }
            case UNION: {
                return new UnionColumnReader(type, column, memoryContext, blockFactory, fieldMapperFactory);
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + column.getColumnType());
    }
}

