/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.accumulo.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.plugin.accumulo.model.SerializedRange;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSplit;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.accumulo.core.data.Range;
import org.openjdk.jol.info.ClassLayout;

public class AccumuloSplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(AccumuloSplit.class).instanceSize());
    private final Optional<String> hostPort;
    private final List<HostAddress> addresses;
    private final List<SerializedRange> ranges;

    @JsonCreator
    public AccumuloSplit(@JsonProperty(value="ranges") List<SerializedRange> ranges, @JsonProperty(value="hostPort") Optional<String> hostPort) {
        this.hostPort = Objects.requireNonNull(hostPort, "hostPort is null");
        this.ranges = ImmutableList.copyOf((Collection)Objects.requireNonNull(ranges, "ranges is null"));
        this.addresses = hostPort.isPresent() ? ImmutableList.of((Object)HostAddress.fromString((String)hostPort.get())) : ImmutableList.of();
    }

    @JsonProperty
    public Optional<String> getHostPort() {
        return this.hostPort;
    }

    @JsonProperty(value="ranges")
    public List<SerializedRange> getSerializedRanges() {
        return this.ranges;
    }

    @JsonIgnore
    public List<Range> getRanges() {
        return this.ranges.stream().map(SerializedRange::deserialize).collect(Collectors.toList());
    }

    public boolean isRemotelyAccessible() {
        return true;
    }

    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    public Object getInfo() {
        return this;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf(this.hostPort, SizeOf::estimatedSizeOf) + SizeOf.estimatedSizeOf(this.addresses, HostAddress::getRetainedSizeInBytes) + SizeOf.estimatedSizeOf(this.ranges, SerializedRange::getRetainedSizeInBytes);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("addresses", this.addresses).add("numRanges", this.ranges.size()).add("hostPort", this.hostPort).toString();
    }
}

