/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.accumulo.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import io.airlift.slice.SizeOf;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.apache.accumulo.core.data.Range;
import org.openjdk.jol.info.ClassLayout;

public class SerializedRange {
    private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(SerializedRange.class).instanceSize());
    private final byte[] bytes;

    public static SerializedRange serialize(Range range) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        try {
            range.write((DataOutput)out);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new SerializedRange(out.toByteArray());
    }

    @JsonCreator
    public SerializedRange(@JsonProperty(value="data") byte[] bytes) {
        this.bytes = Objects.requireNonNull(bytes, "bytes is null");
    }

    @JsonProperty
    public byte[] getBytes() {
        return this.bytes;
    }

    public Range deserialize() {
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])this.bytes);
        Range range = new Range();
        try {
            range.readFields((DataInput)in);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return range;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((byte[])this.bytes);
    }
}

