/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StaticDataTask;
import org.apache.iceberg.StaticTableScan;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class ManifestsTable
extends BaseMetadataTable {
    private static final Schema SNAPSHOT_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)14, (String)"content", (Type)Types.IntegerType.get()), Types.NestedField.required((int)1, (String)"path", (Type)Types.StringType.get()), Types.NestedField.required((int)2, (String)"length", (Type)Types.LongType.get()), Types.NestedField.required((int)3, (String)"partition_spec_id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)4, (String)"added_snapshot_id", (Type)Types.LongType.get()), Types.NestedField.required((int)5, (String)"added_data_files_count", (Type)Types.IntegerType.get()), Types.NestedField.required((int)6, (String)"existing_data_files_count", (Type)Types.IntegerType.get()), Types.NestedField.required((int)7, (String)"deleted_data_files_count", (Type)Types.IntegerType.get()), Types.NestedField.required((int)15, (String)"added_delete_files_count", (Type)Types.IntegerType.get()), Types.NestedField.required((int)16, (String)"existing_delete_files_count", (Type)Types.IntegerType.get()), Types.NestedField.required((int)17, (String)"deleted_delete_files_count", (Type)Types.IntegerType.get()), Types.NestedField.required((int)8, (String)"partition_summaries", (Type)Types.ListType.ofRequired((int)9, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"contains_null", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)11, (String)"contains_nan", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)12, (String)"lower_bound", (Type)Types.StringType.get()), Types.NestedField.optional((int)13, (String)"upper_bound", (Type)Types.StringType.get())})))});

    ManifestsTable(TableOperations ops, Table table) {
        this(ops, table, table.name() + ".manifests");
    }

    ManifestsTable(TableOperations ops, Table table, String name) {
        super(ops, table, name);
    }

    public TableScan newScan() {
        return new ManifestsTableScan(this.operations(), this.table());
    }

    public Schema schema() {
        return SNAPSHOT_SCHEMA;
    }

    @Override
    MetadataTableType metadataTableType() {
        return MetadataTableType.MANIFESTS;
    }

    protected DataTask task(TableScan scan) {
        TableOperations ops = this.operations();
        String location = scan.snapshot().manifestListLocation();
        HashMap specs = Maps.newHashMap((Map)this.table().specs());
        return StaticDataTask.of(ops.io().newInputFile(location != null ? location : ops.current().metadataFileLocation()), this.schema(), scan.schema(), scan.snapshot().allManifests(ops.io()), manifest -> {
            PartitionSpec spec = (PartitionSpec)specs.get(manifest.partitionSpecId());
            return ManifestsTable.manifestFileToRow(spec, manifest);
        });
    }

    static StaticDataTask.Row manifestFileToRow(PartitionSpec spec, ManifestFile manifest) {
        return StaticDataTask.Row.of(manifest.content().id(), manifest.path(), manifest.length(), manifest.partitionSpecId(), manifest.snapshotId(), manifest.content() == ManifestContent.DATA ? manifest.addedFilesCount() : 0, manifest.content() == ManifestContent.DATA ? manifest.existingFilesCount() : 0, manifest.content() == ManifestContent.DATA ? manifest.deletedFilesCount() : 0, manifest.content() == ManifestContent.DELETES ? manifest.addedFilesCount() : 0, manifest.content() == ManifestContent.DELETES ? manifest.existingFilesCount() : 0, manifest.content() == ManifestContent.DELETES ? manifest.deletedFilesCount() : 0, ManifestsTable.partitionSummariesToRows(spec, manifest.partitions()));
    }

    static List<StaticDataTask.Row> partitionSummariesToRows(PartitionSpec spec, List<ManifestFile.PartitionFieldSummary> summaries) {
        if (summaries == null) {
            return null;
        }
        ArrayList rows = Lists.newArrayList();
        for (int i = 0; i < summaries.size(); ++i) {
            ManifestFile.PartitionFieldSummary summary = summaries.get(i);
            rows.add(StaticDataTask.Row.of(summary.containsNull(), summary.containsNaN(), ((PartitionField)spec.fields().get(i)).transform().toHumanString(Conversions.fromByteBuffer((Type)((Types.NestedField)spec.partitionType().fields().get(i)).type(), (ByteBuffer)summary.lowerBound())), ((PartitionField)spec.fields().get(i)).transform().toHumanString(Conversions.fromByteBuffer((Type)((Types.NestedField)spec.partitionType().fields().get(i)).type(), (ByteBuffer)summary.upperBound()))));
        }
        return rows;
    }

    private class ManifestsTableScan
    extends StaticTableScan {
        ManifestsTableScan(TableOperations ops, Table table) {
            super(ops, table, SNAPSHOT_SCHEMA, MetadataTableType.MANIFESTS, ManifestsTable.this::task);
        }
    }
}

