/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.UnboundPartitionSpec;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.JsonUtil;
import org.apache.iceberg.util.Pair;

public class PartitionSpecParser {
    private static final String SPEC_ID = "spec-id";
    private static final String FIELDS = "fields";
    private static final String SOURCE_ID = "source-id";
    private static final String FIELD_ID = "field-id";
    private static final String TRANSFORM = "transform";
    private static final String NAME = "name";
    private static final Cache<Pair<Types.StructType, String>, PartitionSpec> SPEC_CACHE = Caffeine.newBuilder().weakValues().build();

    private PartitionSpecParser() {
    }

    public static void toJson(PartitionSpec spec, JsonGenerator generator) throws IOException {
        PartitionSpecParser.toJson(spec.toUnbound(), generator);
    }

    public static String toJson(PartitionSpec spec) {
        return PartitionSpecParser.toJson(spec, false);
    }

    public static String toJson(PartitionSpec spec, boolean pretty) {
        return PartitionSpecParser.toJson(spec.toUnbound(), pretty);
    }

    public static void toJson(UnboundPartitionSpec spec, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeNumberField(SPEC_ID, spec.specId());
        generator.writeFieldName(FIELDS);
        PartitionSpecParser.toJsonFields(spec, generator);
        generator.writeEndObject();
    }

    public static String toJson(UnboundPartitionSpec spec) {
        return PartitionSpecParser.toJson(spec, false);
    }

    public static String toJson(UnboundPartitionSpec spec, boolean pretty) {
        try {
            StringWriter writer = new StringWriter();
            JsonGenerator generator = JsonUtil.factory().createGenerator((Writer)writer);
            if (pretty) {
                generator.useDefaultPrettyPrinter();
            }
            PartitionSpecParser.toJson(spec, generator);
            generator.flush();
            return writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static PartitionSpec fromJson(Schema schema, JsonNode json) {
        return PartitionSpecParser.fromJson(json).bind(schema);
    }

    public static UnboundPartitionSpec fromJson(JsonNode json) {
        Preconditions.checkArgument((boolean)json.isObject(), (String)"Cannot parse spec from non-object: %s", (Object)json);
        int specId = JsonUtil.getInt(SPEC_ID, json);
        UnboundPartitionSpec.Builder builder = UnboundPartitionSpec.builder().withSpecId(specId);
        PartitionSpecParser.buildFromJsonFields(builder, JsonUtil.get(FIELDS, json));
        return builder.build();
    }

    public static PartitionSpec fromJson(Schema schema, String json) {
        return (PartitionSpec)SPEC_CACHE.get(Pair.of(schema.asStruct(), json), schemaJsonPair -> {
            try {
                return PartitionSpecParser.fromJson(schema, (JsonNode)JsonUtil.mapper().readValue(json, JsonNode.class));
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        });
    }

    static void toJsonFields(PartitionSpec spec, JsonGenerator generator) throws IOException {
        PartitionSpecParser.toJsonFields(spec.toUnbound(), generator);
    }

    static void toJsonFields(UnboundPartitionSpec spec, JsonGenerator generator) throws IOException {
        generator.writeStartArray();
        for (UnboundPartitionSpec.UnboundPartitionField field : spec.fields()) {
            generator.writeStartObject();
            generator.writeStringField(NAME, field.name());
            generator.writeStringField(TRANSFORM, field.transformAsString());
            generator.writeNumberField(SOURCE_ID, field.sourceId());
            generator.writeNumberField(FIELD_ID, field.partitionId().intValue());
            generator.writeEndObject();
        }
        generator.writeEndArray();
    }

    static String toJsonFields(PartitionSpec spec) {
        try {
            StringWriter writer = new StringWriter();
            JsonGenerator generator = JsonUtil.factory().createGenerator((Writer)writer);
            PartitionSpecParser.toJsonFields(spec, generator);
            generator.flush();
            return writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    static PartitionSpec fromJsonFields(Schema schema, int specId, JsonNode json) {
        UnboundPartitionSpec.Builder builder = UnboundPartitionSpec.builder().withSpecId(specId);
        PartitionSpecParser.buildFromJsonFields(builder, json);
        return builder.build().bind(schema);
    }

    static PartitionSpec fromJsonFields(Schema schema, int specId, String json) {
        try {
            return PartitionSpecParser.fromJsonFields(schema, specId, (JsonNode)JsonUtil.mapper().readValue(json, JsonNode.class));
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to parse partition spec fields: %s", new Object[]{json});
        }
    }

    private static void buildFromJsonFields(UnboundPartitionSpec.Builder builder, JsonNode json) {
        Preconditions.checkArgument((boolean)json.isArray(), (String)"Cannot parse partition spec fields, not an array: %s", (Object)json);
        Iterator elements = json.elements();
        int fieldIdCount = 0;
        while (elements.hasNext()) {
            JsonNode element = (JsonNode)elements.next();
            Preconditions.checkArgument((boolean)element.isObject(), (String)"Cannot parse partition field, not an object: %s", (Object)element);
            String name = JsonUtil.getString(NAME, element);
            String transform = JsonUtil.getString(TRANSFORM, element);
            int sourceId = JsonUtil.getInt(SOURCE_ID, element);
            if (element.has(FIELD_ID)) {
                builder.addField(transform, sourceId, JsonUtil.getInt(FIELD_ID, element), name);
                ++fieldIdCount;
                continue;
            }
            builder.addField(transform, sourceId, name);
        }
        Preconditions.checkArgument((fieldIdCount == 0 || fieldIdCount == json.size() ? 1 : 0) != 0, (String)"Cannot parse spec with missing field IDs: %s missing of %s fields.", (int)(json.size() - fieldIdCount), (int)json.size());
    }
}

