/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hadoop;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    public static final String VERSION_HINT_FILENAME = "version-hint.text";
    private static final Logger LOG = LoggerFactory.getLogger(Util.class);

    private Util() {
    }

    public static FileSystem getFs(Path path, Configuration conf) {
        try {
            return path.getFileSystem(conf);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to get file system for path: %s", new Object[]{path});
        }
    }

    public static String[] blockLocations(CombinedScanTask task, Configuration conf) {
        HashSet locationSets = Sets.newHashSet();
        for (FileScanTask f : task.files()) {
            Path path = new Path(((DataFile)f.file()).path().toString());
            try {
                FileSystem fs = path.getFileSystem(conf);
                for (BlockLocation b : fs.getFileBlockLocations(path, f.start(), f.length())) {
                    locationSets.addAll(Arrays.asList(b.getHosts()));
                }
            }
            catch (IOException ioe) {
                LOG.warn("Failed to get block locations for path {}", (Object)path, (Object)ioe);
            }
        }
        return locationSets.toArray(new String[0]);
    }

    public static String[] blockLocations(FileIO io, CombinedScanTask task) {
        HashSet locations = Sets.newHashSet();
        for (FileScanTask f : task.files()) {
            InputFile in = io.newInputFile(((DataFile)f.file()).path().toString());
            if (!(in instanceof HadoopInputFile)) continue;
            Collections.addAll(locations, ((HadoopInputFile)in).getBlockLocations(f.start(), f.length()));
        }
        return locations.toArray(HadoopInputFile.NO_LOCATION_PREFERENCE);
    }

    public static String uriToString(URI uri) {
        return new Path(uri).toString();
    }
}

