/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.deletes.EqualityDeleteWriter;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.io.DataWriter;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.SortedPosDeleteWriter;
import org.apache.iceberg.io.StructCopy;
import org.apache.iceberg.io.TaskWriter;
import org.apache.iceberg.io.WriteResult;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.util.CharSequenceSet;
import org.apache.iceberg.util.StructLikeMap;
import org.apache.iceberg.util.StructProjection;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.util.ThreadPools;

public abstract class BaseTaskWriter<T>
implements TaskWriter<T> {
    private final List<DataFile> completedDataFiles = Lists.newArrayList();
    private final List<DeleteFile> completedDeleteFiles = Lists.newArrayList();
    private final CharSequenceSet referencedDataFiles = CharSequenceSet.empty();
    private final PartitionSpec spec;
    private final FileFormat format;
    private final FileAppenderFactory<T> appenderFactory;
    private final OutputFileFactory fileFactory;
    private final FileIO io;
    private final long targetFileSize;
    private Throwable failure;

    protected BaseTaskWriter(PartitionSpec spec, FileFormat format, FileAppenderFactory<T> appenderFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSize) {
        this.spec = spec;
        this.format = format;
        this.appenderFactory = appenderFactory;
        this.fileFactory = fileFactory;
        this.io = io;
        this.targetFileSize = targetFileSize;
    }

    protected PartitionSpec spec() {
        return this.spec;
    }

    protected void setFailure(Throwable throwable) {
        if (this.failure == null) {
            this.failure = throwable;
        }
    }

    @Override
    public void abort() throws IOException {
        this.close();
        Tasks.foreach(Iterables.concat(this.completedDataFiles, this.completedDeleteFiles)).executeWith(ThreadPools.getWorkerPool()).throwFailureWhenFinished().noRetry().run(file -> this.io.deleteFile(file.path().toString()));
    }

    @Override
    public WriteResult complete() throws IOException {
        this.close();
        Preconditions.checkState((this.failure == null ? 1 : 0) != 0, (String)"Cannot return results from failed writer", (Object)this.failure);
        return WriteResult.builder().addDataFiles(this.completedDataFiles).addDeleteFiles(this.completedDeleteFiles).addReferencedDataFiles((Iterable<CharSequence>)this.referencedDataFiles).build();
    }

    protected class RollingEqDeleteWriter
    extends BaseRollingWriter<EqualityDeleteWriter<T>> {
        RollingEqDeleteWriter(StructLike partitionKey) {
            super(partitionKey);
        }

        @Override
        EqualityDeleteWriter<T> newWriter(EncryptedOutputFile file, StructLike partitionKey) {
            return BaseTaskWriter.this.appenderFactory.newEqDeleteWriter(file, BaseTaskWriter.this.format, partitionKey);
        }

        @Override
        long length(EqualityDeleteWriter<T> writer) {
            return writer.length();
        }

        @Override
        void write(EqualityDeleteWriter<T> writer, T record) {
            writer.delete(record);
        }

        @Override
        void complete(EqualityDeleteWriter<T> closedWriter) {
            BaseTaskWriter.this.completedDeleteFiles.add(closedWriter.toDeleteFile());
        }
    }

    protected class RollingFileWriter
    extends BaseRollingWriter<DataWriter<T>> {
        public RollingFileWriter(StructLike partitionKey) {
            super(partitionKey);
        }

        @Override
        DataWriter<T> newWriter(EncryptedOutputFile file, StructLike partitionKey) {
            return BaseTaskWriter.this.appenderFactory.newDataWriter(file, BaseTaskWriter.this.format, partitionKey);
        }

        @Override
        long length(DataWriter<T> writer) {
            return writer.length();
        }

        @Override
        void write(DataWriter<T> writer, T record) {
            writer.write(record);
        }

        @Override
        void complete(DataWriter<T> closedWriter) {
            BaseTaskWriter.this.completedDataFiles.add(closedWriter.toDataFile());
        }
    }

    private abstract class BaseRollingWriter<W extends Closeable>
    implements Closeable {
        private static final int ROWS_DIVISOR = 1000;
        private final StructLike partitionKey;
        private EncryptedOutputFile currentFile = null;
        private W currentWriter = null;
        private long currentRows = 0L;

        private BaseRollingWriter(StructLike partitionKey) {
            this.partitionKey = partitionKey;
            this.openCurrent();
        }

        abstract W newWriter(EncryptedOutputFile var1, StructLike var2);

        abstract long length(W var1);

        abstract void write(W var1, T var2);

        abstract void complete(W var1);

        public void write(T record) throws IOException {
            this.write(this.currentWriter, record);
            ++this.currentRows;
            if (this.shouldRollToNewFile()) {
                this.closeCurrent();
                this.openCurrent();
            }
        }

        public CharSequence currentPath() {
            Preconditions.checkNotNull((Object)this.currentFile, (Object)"The currentFile shouldn't be null");
            return this.currentFile.encryptingOutputFile().location();
        }

        public long currentRows() {
            return this.currentRows;
        }

        private void openCurrent() {
            this.currentFile = this.partitionKey == null ? BaseTaskWriter.this.fileFactory.newOutputFile() : BaseTaskWriter.this.fileFactory.newOutputFile(this.partitionKey);
            this.currentWriter = this.newWriter(this.currentFile, this.partitionKey);
            this.currentRows = 0L;
        }

        private boolean shouldRollToNewFile() {
            return this.currentRows % 1000L == 0L && this.length(this.currentWriter) >= BaseTaskWriter.this.targetFileSize;
        }

        private void closeCurrent() throws IOException {
            if (this.currentWriter != null) {
                try {
                    this.currentWriter.close();
                    if (this.currentRows == 0L) {
                        try {
                            BaseTaskWriter.this.io.deleteFile(this.currentFile.encryptingOutputFile());
                        }
                        catch (UncheckedIOException uncheckedIOException) {}
                    } else {
                        this.complete(this.currentWriter);
                    }
                }
                catch (IOException | RuntimeException e) {
                    BaseTaskWriter.this.setFailure(e);
                    throw e;
                }
                finally {
                    this.currentFile = null;
                    this.currentWriter = null;
                    this.currentRows = 0L;
                }
            }
        }

        @Override
        public void close() throws IOException {
            this.closeCurrent();
        }
    }

    private static class PathOffset {
        private final CharSequence path;
        private final long rowOffset;

        private PathOffset(CharSequence path, long rowOffset) {
            this.path = path;
            this.rowOffset = rowOffset;
        }

        private static PathOffset of(CharSequence path, long rowOffset) {
            return new PathOffset(path, rowOffset);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("path", (Object)this.path).add("row_offset", this.rowOffset).toString();
        }
    }

    protected abstract class BaseEqualityDeltaWriter
    implements Closeable {
        private final StructProjection structProjection;
        private RollingFileWriter dataWriter;
        private RollingEqDeleteWriter eqDeleteWriter;
        private SortedPosDeleteWriter<T> posDeleteWriter;
        private Map<StructLike, PathOffset> insertedRowMap;

        protected BaseEqualityDeltaWriter(StructLike partition, Schema schema, Schema deleteSchema) {
            Preconditions.checkNotNull((Object)schema, (Object)"Iceberg table schema cannot be null.");
            Preconditions.checkNotNull((Object)deleteSchema, (Object)"Equality-delete schema cannot be null.");
            this.structProjection = StructProjection.create((Schema)schema, (Schema)deleteSchema);
            this.dataWriter = new RollingFileWriter(partition);
            this.eqDeleteWriter = new RollingEqDeleteWriter(partition);
            this.posDeleteWriter = new SortedPosDeleteWriter(BaseTaskWriter.this.appenderFactory, BaseTaskWriter.this.fileFactory, BaseTaskWriter.this.format, partition);
            this.insertedRowMap = StructLikeMap.create(deleteSchema.asStruct());
        }

        protected abstract StructLike asStructLike(T var1);

        protected abstract StructLike asStructLikeKey(T var1);

        public void write(T row) throws IOException {
            PathOffset pathOffset = PathOffset.of(this.dataWriter.currentPath(), this.dataWriter.currentRows());
            StructLike copiedKey = StructCopy.copy((StructLike)this.structProjection.wrap(this.asStructLike(row)));
            PathOffset previous = this.insertedRowMap.put(copiedKey, pathOffset);
            if (previous != null) {
                this.posDeleteWriter.delete(previous.path, previous.rowOffset, null);
            }
            this.dataWriter.write(row);
        }

        private boolean internalPosDelete(StructLike key) {
            PathOffset previous = this.insertedRowMap.remove(key);
            if (previous != null) {
                this.posDeleteWriter.delete(previous.path, previous.rowOffset, null);
                return true;
            }
            return false;
        }

        public void delete(T row) throws IOException {
            if (!this.internalPosDelete((StructLike)this.structProjection.wrap(this.asStructLike(row)))) {
                this.eqDeleteWriter.write(row);
            }
        }

        public void deleteKey(T key) throws IOException {
            if (!this.internalPosDelete(this.asStructLikeKey(key))) {
                this.eqDeleteWriter.write(key);
            }
        }

        @Override
        public void close() throws IOException {
            block16: {
                try {
                    if (this.dataWriter != null) {
                        try {
                            this.dataWriter.close();
                        }
                        finally {
                            this.dataWriter = null;
                        }
                    }
                    if (this.eqDeleteWriter != null) {
                        try {
                            this.eqDeleteWriter.close();
                        }
                        finally {
                            this.eqDeleteWriter = null;
                        }
                    }
                    if (this.insertedRowMap != null) {
                        this.insertedRowMap.clear();
                        this.insertedRowMap = null;
                    }
                    if (this.posDeleteWriter == null) break block16;
                    try {
                        BaseTaskWriter.this.completedDeleteFiles.addAll(this.posDeleteWriter.complete());
                        BaseTaskWriter.this.referencedDataFiles.addAll((Collection)this.posDeleteWriter.referencedDataFiles());
                    }
                    finally {
                        this.posDeleteWriter = null;
                    }
                }
                catch (IOException | RuntimeException e) {
                    BaseTaskWriter.this.setFailure(e);
                    throw e;
                }
            }
        }
    }
}

