/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jmx;

import io.airlift.log.Logger;
import io.trino.plugin.jmx.JmxMetadata;
import io.trino.plugin.jmx.JmxPeriodicSampler;
import io.trino.plugin.jmx.JmxRecordSetProvider;
import io.trino.plugin.jmx.JmxSplitManager;
import io.trino.plugin.jmx.JmxTransactionHandle;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.transaction.IsolationLevel;
import java.util.Objects;
import javax.inject.Inject;

public class JmxConnector
implements Connector {
    private static final Logger log = Logger.get(JmxConnector.class);
    private final JmxMetadata jmxMetadata;
    private final JmxPeriodicSampler jmxPeriodicSampler;
    private final JmxSplitManager jmxSplitManager;
    private final JmxRecordSetProvider jmxRecordSetProvider;

    @Inject
    public JmxConnector(JmxMetadata jmxMetadata, JmxSplitManager jmxSplitManager, JmxRecordSetProvider jmxRecordSetProvider, JmxPeriodicSampler jmxPeriodicSampler) {
        this.jmxMetadata = Objects.requireNonNull(jmxMetadata, "jmxMetadata is null");
        this.jmxSplitManager = Objects.requireNonNull(jmxSplitManager, "jmxSplitManager is null");
        this.jmxRecordSetProvider = Objects.requireNonNull(jmxRecordSetProvider, "jmxRecordSetProvider is null");
        this.jmxPeriodicSampler = Objects.requireNonNull(jmxPeriodicSampler, "jmxPeriodicSampler is null");
    }

    public JmxMetadata getMetadata(ConnectorSession session, ConnectorTransactionHandle transactionHandle) {
        return this.jmxMetadata;
    }

    public JmxSplitManager getSplitManager() {
        return this.jmxSplitManager;
    }

    public JmxRecordSetProvider getRecordSetProvider() {
        return this.jmxRecordSetProvider;
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
        IsolationLevel.checkConnectorSupports((IsolationLevel)IsolationLevel.READ_COMMITTED, (IsolationLevel)isolationLevel);
        return JmxTransactionHandle.INSTANCE;
    }

    public void shutdown() {
        try {
            this.jmxPeriodicSampler.shutdown();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error shutting down connector");
        }
    }
}

