/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.aws.athena;

import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.trino.plugin.hive.aws.athena.projection.Projection;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.common.FileUtils;

public final class PartitionProjection {
    private static final Pattern PROJECTION_LOCATION_TEMPLATE_PLACEHOLDER_PATTERN = Pattern.compile("(\\$\\{[^}]+\\})");
    private final boolean enabled;
    private final Optional<String> storageLocationTemplate;
    private final Map<String, Projection> columnProjections;

    public PartitionProjection(boolean enabled, Optional<String> storageLocationTemplate, Map<String, Projection> columnProjections) {
        this.enabled = enabled;
        this.storageLocationTemplate = Objects.requireNonNull(storageLocationTemplate, "storageLocationTemplate is null");
        this.columnProjections = ImmutableMap.copyOf(Objects.requireNonNull(columnProjections, "columnProjections is null"));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Optional<List<String>> getProjectedPartitionNamesByFilter(List<String> columnNames, TupleDomain<String> partitionKeysFilter) {
        if (partitionKeysFilter.isNone()) {
            return Optional.empty();
        }
        Map columnDomainMap = (Map)partitionKeysFilter.getDomains().orElseThrow(VerifyException::new);
        columnNames.stream().forEach(columnName -> Preconditions.checkArgument((boolean)this.columnProjections.containsKey(columnName), (Object)Projection.invalidProjectionMessage(columnName, "Projection not defined for this column")));
        List projectedPartitionValues = (List)columnNames.stream().map(columnName -> (ImmutableSet)this.columnProjections.get(columnName).getProjectedValues(Optional.ofNullable((Domain)columnDomainMap.get(columnName))).stream().map(projectedValue -> FileUtils.escapePathName((String)columnName) + "=" + FileUtils.escapePathName((String)projectedValue)).collect(ImmutableSet.toImmutableSet())).collect(ImmutableList.toImmutableList());
        return Optional.of((List)Sets.cartesianProduct((List)projectedPartitionValues).stream().map(parts -> String.join((CharSequence)"/", parts)).collect(ImmutableList.toImmutableList()));
    }

    public Map<String, Optional<Partition>> getProjectedPartitionsByNames(Table table, List<String> partitionNames) {
        return partitionNames.stream().collect(Collectors.toMap(partitionName -> partitionName, partitionName -> Optional.of(this.buildPartitionObject(table, (String)partitionName))));
    }

    private Partition buildPartitionObject(Table table, String partitionName) {
        List<String> partitionValues = HiveUtil.toPartitionValues(partitionName);
        return Partition.builder().setDatabaseName(table.getDatabaseName()).setTableName(table.getTableName()).setColumns(table.getDataColumns()).setValues(partitionValues).setParameters(Map.of()).withStorage(storage -> storage.setStorageFormat(table.getStorage().getStorageFormat()).setLocation(this.storageLocationTemplate.map(template -> this.expandStorageLocationTemplate((String)template, table.getPartitionColumns().stream().map(column -> column.getName()).collect(Collectors.toList()), partitionValues)).orElse(String.format("%s/%s/", table.getStorage().getLocation(), partitionName))).setBucketProperty(table.getStorage().getBucketProperty()).setSerdeParameters(table.getStorage().getSerdeParameters())).build();
    }

    private String expandStorageLocationTemplate(String template, List<String> partitionColumns, List<String> partitionValues) {
        Matcher matcher = PROJECTION_LOCATION_TEMPLATE_PLACEHOLDER_PATTERN.matcher(template);
        StringBuilder location = new StringBuilder();
        while (matcher.find()) {
            String columnPlaceholder = matcher.group(1);
            String columnName = columnPlaceholder.substring(2, columnPlaceholder.length() - 1);
            matcher.appendReplacement(location, partitionValues.get(partitionColumns.indexOf(columnName)));
        }
        matcher.appendTail(location);
        return location.toString();
    }
}

