/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.trino.collect.cache.NonEvictableLoadingCache;
import io.trino.collect.cache.SafeCaches;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.metastore.thrift.IdentityAwareMetastoreClientFactory;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreConfig;
import io.trino.plugin.hive.metastore.thrift.TokenAwareMetastoreClientFactory;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.thrift.TException;

public class TokenFetchingMetastoreClientFactory
implements IdentityAwareMetastoreClientFactory {
    private final TokenAwareMetastoreClientFactory clientProvider;
    private final boolean impersonationEnabled;
    private final NonEvictableLoadingCache<String, String> delegationTokenCache;

    @Inject
    public TokenFetchingMetastoreClientFactory(TokenAwareMetastoreClientFactory tokenAwareMetastoreClientFactory, ThriftMetastoreConfig thriftConfig) {
        this.clientProvider = Objects.requireNonNull(tokenAwareMetastoreClientFactory, "tokenAwareMetastoreClientFactory is null");
        this.impersonationEnabled = thriftConfig.isImpersonationEnabled();
        this.delegationTokenCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().expireAfterWrite(thriftConfig.getDelegationTokenCacheTtl().toMillis(), TimeUnit.MILLISECONDS).maximumSize(thriftConfig.getDelegationTokenCacheMaximumSize()), (CacheLoader)CacheLoader.from(this::loadDelegationToken));
    }

    private ThriftMetastoreClient createMetastoreClient() throws TException {
        return this.clientProvider.createMetastoreClient(Optional.empty());
    }

    @Override
    public ThriftMetastoreClient createMetastoreClientFor(Optional<ConnectorIdentity> identity) throws TException {
        String delegationToken;
        if (!this.impersonationEnabled) {
            return this.createMetastoreClient();
        }
        String username = identity.map(ConnectorIdentity::getUser).orElseThrow(() -> new IllegalStateException("End-user name should exist when metastore impersonation is enabled"));
        try {
            delegationToken = (String)this.delegationTokenCache.getUnchecked((Object)username);
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), TrinoException.class);
            throw e;
        }
        return this.clientProvider.createMetastoreClient(Optional.of(delegationToken));
    }

    private String loadDelegationToken(String username) {
        ThriftMetastoreClient client = this.createMetastoreClient();
        try {
            String string = client.getDelegationToken(username);
            if (client != null) {
                client.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (TException e) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
            }
        }
    }
}

