/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoInputFile;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.parquet.ParquetCorruptionException;
import io.trino.parquet.ParquetDataSource;
import io.trino.parquet.ParquetDataSourceId;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.parquet.ParquetTypeUtils;
import io.trino.parquet.ParquetWriteValidation;
import io.trino.parquet.predicate.Predicate;
import io.trino.parquet.predicate.PredicateUtils;
import io.trino.parquet.reader.MetadataReader;
import io.trino.parquet.reader.ParquetReader;
import io.trino.parquet.reader.ParquetReaderColumn;
import io.trino.parquet.reader.TrinoColumnIndexStore;
import io.trino.plugin.hive.AcidInfo;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HivePageSourceFactory;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.ReaderColumns;
import io.trino.plugin.hive.ReaderPageSource;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.parquet.ParquetPageSource;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.plugin.hive.parquet.TrinoParquetDataSource;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.internal.filter2.columnindex.ColumnIndexStore;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.GroupColumnIO;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.joda.time.DateTimeZone;

public class ParquetPageSourceFactory
implements HivePageSourceFactory {
    public static final HiveColumnHandle PARQUET_ROW_INDEX_COLUMN = new HiveColumnHandle("$parquet$row_index", -1, HiveType.HIVE_LONG, (io.trino.spi.type.Type)BigintType.BIGINT, Optional.empty(), HiveColumnHandle.ColumnType.SYNTHESIZED, Optional.empty());
    private static final Set<String> PARQUET_SERDE_CLASS_NAMES = ImmutableSet.builder().add((Object)"org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe").add((Object)"parquet.hive.serde.ParquetHiveSerDe").build();
    private final TrinoFileSystemFactory fileSystemFactory;
    private final FileFormatDataSourceStats stats;
    private final ParquetReaderOptions options;
    private final DateTimeZone timeZone;

    @Inject
    public ParquetPageSourceFactory(TrinoFileSystemFactory fileSystemFactory, FileFormatDataSourceStats stats, ParquetReaderConfig config, HiveConfig hiveConfig) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.options = config.toParquetReaderOptions();
        this.timeZone = hiveConfig.getParquetDateTimeZone();
    }

    @Override
    public Optional<ReaderPageSource> createPageSource(Configuration configuration, ConnectorSession session, Path path, long start, long length, long estimatedFileSize, Properties schema, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, Optional<AcidInfo> acidInfo, OptionalInt bucketNumber, boolean originalFile, AcidTransaction transaction) {
        if (!PARQUET_SERDE_CLASS_NAMES.contains(HiveUtil.getDeserializerClassName(schema))) {
            return Optional.empty();
        }
        Preconditions.checkArgument((boolean)acidInfo.isEmpty(), (Object)"Acid is not supported");
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
        TrinoInputFile inputFile = fileSystem.newInputFile(path.toString(), estimatedFileSize);
        return Optional.of(ParquetPageSourceFactory.createPageSource(inputFile, start, length, columns, effectivePredicate, HiveSessionProperties.isUseParquetColumnNames(session), this.timeZone, this.stats, this.options.withIgnoreStatistics(HiveSessionProperties.isParquetIgnoreStatistics(session)).withMaxReadBlockSize(HiveSessionProperties.getParquetMaxReadBlockSize(session)).withUseColumnIndex(HiveSessionProperties.isParquetUseColumnIndex(session)), Optional.empty()));
    }

    public static ReaderPageSource createPageSource(TrinoInputFile inputFile, long start, long length, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, boolean useColumnNames, DateTimeZone timeZone, FileFormatDataSourceStats stats, ParquetReaderOptions options, Optional<ParquetWriteValidation> parquetWriteValidation) {
        effectivePredicate = effectivePredicate.filter((column, domain) -> column.isBaseColumn());
        TrinoParquetDataSource dataSource = null;
        try {
            dataSource = new TrinoParquetDataSource(inputFile, options, stats);
            ParquetMetadata parquetMetadata = MetadataReader.readFooter((ParquetDataSource)dataSource, parquetWriteValidation);
            FileMetaData fileMetaData = parquetMetadata.getFileMetaData();
            MessageType fileSchema = fileMetaData.getSchema();
            Optional<MessageType> message = ParquetPageSourceFactory.getParquetMessageType(columns, useColumnNames, fileSchema);
            MessageType requestedSchema = message.orElse(new MessageType(fileSchema.getName(), (List)ImmutableList.of()));
            MessageColumnIO messageColumn = ParquetTypeUtils.getColumnIO((MessageType)fileSchema, (MessageType)requestedSchema);
            Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)requestedSchema);
            TupleDomain<ColumnDescriptor> parquetTupleDomain = options.isIgnoreStatistics() ? TupleDomain.all() : ParquetPageSourceFactory.getParquetTupleDomain(descriptorsByPath, (TupleDomain<HiveColumnHandle>)effectivePredicate, fileSchema, useColumnNames);
            Predicate parquetPredicate = PredicateUtils.buildPredicate((MessageType)requestedSchema, parquetTupleDomain, (Map)descriptorsByPath, (DateTimeZone)timeZone);
            long nextStart = 0L;
            ImmutableList.Builder blocks = ImmutableList.builder();
            ImmutableList.Builder blockStarts = ImmutableList.builder();
            ImmutableList.Builder columnIndexes = ImmutableList.builder();
            for (BlockMetaData block : parquetMetadata.getBlocks()) {
                long firstDataPage = ((ColumnChunkMetaData)block.getColumns().get(0)).getFirstDataPageOffset();
                Optional<ColumnIndexStore> columnIndex = ParquetPageSourceFactory.getColumnIndexStore((ParquetDataSource)dataSource, block, descriptorsByPath, parquetTupleDomain, options);
                if (start <= firstDataPage && firstDataPage < start + length && PredicateUtils.predicateMatches((Predicate)parquetPredicate, (BlockMetaData)block, (ParquetDataSource)dataSource, (Map)descriptorsByPath, parquetTupleDomain, columnIndex, (DateTimeZone)timeZone)) {
                    blocks.add((Object)block);
                    blockStarts.add((Object)nextStart);
                    columnIndexes.add(columnIndex);
                }
                nextStart += block.getRowCount();
            }
            Optional<ReaderColumns> readerProjections = HivePageSourceProvider.projectBaseColumns(columns);
            List<HiveColumnHandle> baseColumns = readerProjections.map(projection -> projection.get().stream().map(HiveColumnHandle.class::cast).collect(Collectors.toUnmodifiableList())).orElse(columns);
            List<ParquetReaderColumn> parquetReaderColumns = ParquetPageSourceFactory.createParquetReaderColumns(baseColumns, fileSchema, messageColumn, useColumnNames);
            ParquetDataSourceId dataSourceId = dataSource.getId();
            ParquetPageSource parquetPageSource = new ParquetPageSource(new ParquetReader(Optional.ofNullable(fileMetaData.getCreatedBy()), ParquetReaderColumn.getParquetReaderFields(parquetReaderColumns), (List)blocks.build(), (List)blockStarts.build(), (ParquetDataSource)dataSource, timeZone, AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), options, exception -> ParquetPageSource.handleException(dataSourceId, exception), Optional.of(parquetPredicate), (List)columnIndexes.build(), parquetWriteValidation), parquetReaderColumns);
            return new ReaderPageSource(parquetPageSource, readerProjections);
        }
        catch (Exception e) {
            try {
                if (dataSource != null) {
                    dataSource.close();
                }
            }
            catch (IOException fileMetaData) {
                // empty catch block
            }
            if (e instanceof TrinoException) {
                throw (TrinoException)((Object)e);
            }
            if (e instanceof ParquetCorruptionException) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, (Throwable)e);
            }
            if (Strings.nullToEmpty((String)e.getMessage()).trim().equals("Filesystem closed") || e instanceof FileNotFoundException) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, (Throwable)e);
            }
            String message = String.format("Error opening Hive split %s (offset=%s, length=%s): %s", inputFile.location(), start, length, e.getMessage());
            if (e instanceof BlockMissingException) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_MISSING_DATA, message, (Throwable)e);
            }
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, message, (Throwable)e);
        }
    }

    public static Optional<MessageType> getParquetMessageType(List<HiveColumnHandle> columns, boolean useColumnNames, MessageType fileSchema) {
        Optional<MessageType> message = HivePageSourceProvider.projectSufficientColumns(columns).map(projection -> projection.get().stream().map(HiveColumnHandle.class::cast).collect(Collectors.toUnmodifiableList())).orElse(columns).stream().filter(column -> column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR).map(column -> ParquetPageSourceFactory.getColumnType(column, fileSchema, useColumnNames)).filter(Optional::isPresent).map(Optional::get).map(type -> new MessageType(fileSchema.getName(), new Type[]{type})).reduce(MessageType::union);
        return message;
    }

    public static Optional<Type> getParquetType(GroupType groupType, boolean useParquetColumnNames, HiveColumnHandle column) {
        if (useParquetColumnNames) {
            return Optional.ofNullable(ParquetTypeUtils.getParquetTypeByName((String)column.getBaseColumnName(), (GroupType)groupType));
        }
        if (column.getBaseHiveColumnIndex() < groupType.getFieldCount()) {
            return Optional.of(groupType.getType(column.getBaseHiveColumnIndex()));
        }
        return Optional.empty();
    }

    public static Optional<Type> getColumnType(HiveColumnHandle column, MessageType messageType, boolean useParquetColumnNames) {
        Optional<Type> columnType = ParquetPageSourceFactory.getParquetType((GroupType)messageType, useParquetColumnNames, column);
        if (columnType.isEmpty() || column.getHiveColumnProjectionInfo().isEmpty()) {
            return columnType;
        }
        GroupType baseType = columnType.get().asGroupType();
        ImmutableList.Builder typeBuilder = ImmutableList.builder();
        GroupType parentType = baseType;
        for (String name : column.getHiveColumnProjectionInfo().get().getDereferenceNames()) {
            Type childType = ParquetTypeUtils.getParquetTypeByName((String)name, (GroupType)parentType.asGroupType());
            if (childType == null) {
                return Optional.empty();
            }
            typeBuilder.add((Object)childType);
            parentType = childType;
        }
        ImmutableList subfieldTypes = typeBuilder.build();
        Type type = (Type)subfieldTypes.get(subfieldTypes.size() - 1);
        for (int i = subfieldTypes.size() - 2; i >= 0; --i) {
            GroupType groupType = ((Type)subfieldTypes.get(i)).asGroupType();
            type = new GroupType(groupType.getRepetition(), groupType.getName(), (List)ImmutableList.of((Object)type));
        }
        return Optional.of(new GroupType(baseType.getRepetition(), baseType.getName(), (List)ImmutableList.of((Object)type)));
    }

    public static Optional<ColumnIndexStore> getColumnIndexStore(ParquetDataSource dataSource, BlockMetaData blockMetadata, Map<List<String>, ColumnDescriptor> descriptorsByPath, TupleDomain<ColumnDescriptor> parquetTupleDomain, ParquetReaderOptions options) {
        if (!options.isUseColumnIndex() || parquetTupleDomain.isAll() || parquetTupleDomain.isNone()) {
            return Optional.empty();
        }
        boolean hasColumnIndex = false;
        for (Object column2 : blockMetadata.getColumns()) {
            if (column2.getColumnIndexReference() == null || column2.getOffsetIndexReference() == null) continue;
            hasColumnIndex = true;
            break;
        }
        if (!hasColumnIndex) {
            return Optional.empty();
        }
        HashSet<ColumnPath> columnsReadPaths = new HashSet<ColumnPath>(descriptorsByPath.size());
        for (List list : descriptorsByPath.keySet()) {
            columnsReadPaths.add(ColumnPath.get((String[])list.toArray(new String[0])));
        }
        Map parquetDomains = (Map)parquetTupleDomain.getDomains().orElseThrow(() -> new IllegalStateException("Predicate other than none should have domains"));
        Set set = (Set)parquetDomains.keySet().stream().map(column -> ColumnPath.get((String[])column.getPath())).collect(ImmutableSet.toImmutableSet());
        return Optional.of(new TrinoColumnIndexStore(dataSource, blockMetadata, columnsReadPaths, set));
    }

    public static TupleDomain<ColumnDescriptor> getParquetTupleDomain(Map<List<String>, ColumnDescriptor> descriptorsByPath, TupleDomain<HiveColumnHandle> effectivePredicate, MessageType fileSchema, boolean useColumnNames) {
        if (effectivePredicate.isNone()) {
            return TupleDomain.none();
        }
        ImmutableMap.Builder predicate = ImmutableMap.builder();
        for (Map.Entry entry : ((Map)effectivePredicate.getDomains().get()).entrySet()) {
            ColumnDescriptor descriptor;
            HiveColumnHandle columnHandle = (HiveColumnHandle)entry.getKey();
            if (columnHandle.getHiveType().getCategory() != ObjectInspector.Category.PRIMITIVE || columnHandle.getColumnType() != HiveColumnHandle.ColumnType.REGULAR) continue;
            if (useColumnNames) {
                descriptor = descriptorsByPath.get(ImmutableList.of((Object)columnHandle.getName()));
            } else {
                Type parquetField = ParquetPageSourceFactory.getParquetType(columnHandle, fileSchema, false);
                if (parquetField == null || !parquetField.isPrimitive()) continue;
                descriptor = descriptorsByPath.get(ImmutableList.of((Object)parquetField.getName()));
            }
            if (descriptor == null) continue;
            predicate.put((Object)descriptor, (Object)((Domain)entry.getValue()));
        }
        return TupleDomain.withColumnDomains((Map)predicate.buildOrThrow());
    }

    public static Type getParquetType(HiveColumnHandle column, MessageType messageType, boolean useParquetColumnNames) {
        if (useParquetColumnNames) {
            return ParquetTypeUtils.getParquetTypeByName((String)column.getBaseColumnName(), (GroupType)messageType);
        }
        if (column.getBaseHiveColumnIndex() < messageType.getFieldCount()) {
            return messageType.getType(column.getBaseHiveColumnIndex());
        }
        return null;
    }

    public static List<ParquetReaderColumn> createParquetReaderColumns(List<HiveColumnHandle> baseColumns, MessageType fileSchema, MessageColumnIO messageColumn, boolean useColumnNames) {
        for (HiveColumnHandle column2 : baseColumns) {
            Preconditions.checkArgument((column2 == PARQUET_ROW_INDEX_COLUMN || column2.getColumnType() == HiveColumnHandle.ColumnType.REGULAR ? 1 : 0) != 0, (String)"column type must be REGULAR: %s", (Object)column2);
        }
        return (List)baseColumns.stream().map(column -> {
            boolean isRowIndexColumn = column == PARQUET_ROW_INDEX_COLUMN;
            return new ParquetReaderColumn(column.getBaseType(), isRowIndexColumn ? Optional.empty() : Optional.ofNullable(ParquetPageSourceFactory.getParquetType(column, fileSchema, useColumnNames)).flatMap(field -> {
                String columnName = useColumnNames ? column.getBaseColumnName() : ((Type)fileSchema.getFields().get(column.getBaseHiveColumnIndex())).getName();
                return ParquetTypeUtils.constructField((io.trino.spi.type.Type)column.getBaseType(), (ColumnIO)ParquetTypeUtils.lookupColumnByName((GroupColumnIO)messageColumn, (String)columnName));
            }), isRowIndexColumn);
        }).collect(ImmutableList.toImmutableList());
    }
}

