/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import org.apache.iceberg.Accessor;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.transforms.Transform;

public class PartitionKey
implements StructLike,
Serializable {
    private final PartitionSpec spec;
    private final int size;
    private final Object[] partitionTuple;
    private final Transform[] transforms;
    private final Accessor<StructLike>[] accessors;

    public PartitionKey(PartitionSpec spec, Schema inputSchema) {
        this.spec = spec;
        List<PartitionField> fields = spec.fields();
        this.size = fields.size();
        this.partitionTuple = new Object[this.size];
        this.transforms = new Transform[this.size];
        this.accessors = (Accessor[])Array.newInstance(Accessor.class, this.size);
        Schema schema = spec.schema();
        for (int i = 0; i < this.size; ++i) {
            PartitionField field = fields.get(i);
            Accessor<StructLike> accessor = inputSchema.accessorForField(field.sourceId());
            Preconditions.checkArgument((accessor != null ? 1 : 0) != 0, (Object)("Cannot build accessor for field: " + schema.findField(field.sourceId())));
            this.accessors[i] = accessor;
            this.transforms[i] = field.transform();
        }
    }

    private PartitionKey(PartitionKey toCopy) {
        this.spec = toCopy.spec;
        this.size = toCopy.size;
        this.partitionTuple = new Object[toCopy.partitionTuple.length];
        this.transforms = toCopy.transforms;
        this.accessors = toCopy.accessors;
        System.arraycopy(toCopy.partitionTuple, 0, this.partitionTuple, 0, this.partitionTuple.length);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this.partitionTuple.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.partitionTuple[i]);
        }
        sb.append("]");
        return sb.toString();
    }

    public PartitionKey copy() {
        return new PartitionKey(this);
    }

    public String toPath() {
        return this.spec.partitionToPath(this);
    }

    public void partition(StructLike row) {
        for (int i = 0; i < this.partitionTuple.length; ++i) {
            Transform transform = this.transforms[i];
            this.partitionTuple[i] = transform.apply(this.accessors[i].get(row));
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public <T> T get(int pos, Class<T> javaClass) {
        return javaClass.cast(this.partitionTuple[pos]);
    }

    @Override
    public <T> void set(int pos, T value) {
        this.partitionTuple[pos] = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PartitionKey)) {
            return false;
        }
        PartitionKey that = (PartitionKey)o;
        return Arrays.equals(this.partitionTuple, that.partitionTuple);
    }

    public int hashCode() {
        return Arrays.hashCode(this.partitionTuple);
    }
}

