/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.ingestion.batch;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.pinot.spi.ingestion.batch.runner.IngestionJobRunner;
import org.apache.pinot.spi.ingestion.batch.spec.ExecutionFrameworkSpec;
import org.apache.pinot.spi.ingestion.batch.spec.SegmentGenerationJobSpec;
import org.apache.pinot.spi.plugin.PluginManager;
import org.apache.pinot.spi.utils.GroovyTemplateUtils;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class IngestionJobLauncher {
    public static final Logger LOGGER = LoggerFactory.getLogger(IngestionJobLauncher.class);
    public static final String JOB_SPEC_FORMAT = "job-spec-format";
    public static final String JSON = "json";
    public static final String YAML = "yaml";

    private IngestionJobLauncher() {
    }

    public static SegmentGenerationJobSpec getSegmentGenerationJobSpec(String jobSpecFilePath, String propertyFilePath, Map<String, Object> context, Map<String, String> environmentValues) {
        String jobSpecStr;
        String jobSpecTemplate;
        Properties properties = new Properties();
        if (propertyFilePath != null) {
            try {
                properties.load(FileUtils.openInputStream((File)new File(propertyFilePath)));
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Unable to read property file [%s] into properties.", propertyFilePath), e);
            }
        }
        Properties propertiesMap = properties;
        if (environmentValues != null) {
            for (String propertyName : propertiesMap.keySet()) {
                if (environmentValues.get(propertyName) == null) continue;
                propertiesMap.put(propertyName, environmentValues.get(propertyName));
            }
        }
        if (context != null) {
            propertiesMap.putAll(context);
        }
        try {
            jobSpecTemplate = IOUtils.toString((Reader)new BufferedReader(new FileReader(jobSpecFilePath)));
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to read ingestion job spec file [%s].", jobSpecFilePath), e);
        }
        try {
            jobSpecStr = GroovyTemplateUtils.renderTemplate(jobSpecTemplate, propertiesMap);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Unable to render templates on ingestion job spec template file - [%s] with propertiesMap - [%s].", jobSpecFilePath, Arrays.toString(propertiesMap.entrySet().toArray())), e);
        }
        String jobSpecFormat = propertiesMap.getOrDefault((Object)JOB_SPEC_FORMAT, YAML);
        if (jobSpecFormat.equals(JSON)) {
            try {
                return JsonUtils.stringToObject(jobSpecStr, SegmentGenerationJobSpec.class);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Unable to parse job spec - [%s] to JSON with propertiesMap - [%s]", jobSpecFilePath, Arrays.toString(propertiesMap.entrySet().toArray())), e);
            }
        }
        return (SegmentGenerationJobSpec)new Yaml().loadAs(jobSpecStr, SegmentGenerationJobSpec.class);
    }

    public static void runIngestionJob(SegmentGenerationJobSpec spec) {
        LOGGER.info("SegmentGenerationJobSpec: \n{}", (Object)spec.toJSONString(true));
        ExecutionFrameworkSpec executionFramework = spec.getExecutionFrameworkSpec();
        PinotIngestionJobType jobType = PinotIngestionJobType.fromString(spec.getJobType());
        switch (jobType) {
            case SegmentCreation: {
                IngestionJobLauncher.kickoffIngestionJob(spec, executionFramework.getSegmentGenerationJobRunnerClassName());
                break;
            }
            case SegmentTarPush: {
                IngestionJobLauncher.kickoffIngestionJob(spec, executionFramework.getSegmentTarPushJobRunnerClassName());
                break;
            }
            case SegmentUriPush: {
                IngestionJobLauncher.kickoffIngestionJob(spec, executionFramework.getSegmentUriPushJobRunnerClassName());
                break;
            }
            case SegmentMetadataPush: {
                IngestionJobLauncher.kickoffIngestionJob(spec, executionFramework.getSegmentMetadataPushJobRunnerClassName());
                break;
            }
            case SegmentCreationAndTarPush: {
                IngestionJobLauncher.kickoffIngestionJob(spec, executionFramework.getSegmentGenerationJobRunnerClassName());
                IngestionJobLauncher.kickoffIngestionJob(spec, executionFramework.getSegmentTarPushJobRunnerClassName());
                break;
            }
            case SegmentCreationAndUriPush: {
                IngestionJobLauncher.kickoffIngestionJob(spec, executionFramework.getSegmentGenerationJobRunnerClassName());
                IngestionJobLauncher.kickoffIngestionJob(spec, executionFramework.getSegmentUriPushJobRunnerClassName());
                break;
            }
            case SegmentCreationAndMetadataPush: {
                IngestionJobLauncher.kickoffIngestionJob(spec, executionFramework.getSegmentGenerationJobRunnerClassName());
                IngestionJobLauncher.kickoffIngestionJob(spec, executionFramework.getSegmentMetadataPushJobRunnerClassName());
                break;
            }
            default: {
                LOGGER.error("Unsupported job type - {}. Support job types: {}", (Object)spec.getJobType(), (Object)Arrays.toString((Object[])PinotIngestionJobType.values()));
                throw new RuntimeException("Unsupported job type - " + spec.getJobType());
            }
        }
    }

    private static void kickoffIngestionJob(SegmentGenerationJobSpec spec, String ingestionJobRunnerClassName) {
        IngestionJobRunner ingestionJobRunner;
        LOGGER.info("Trying to create instance for class {}", (Object)ingestionJobRunnerClassName);
        try {
            ingestionJobRunner = (IngestionJobRunner)PluginManager.get().createInstance(ingestionJobRunnerClassName);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create IngestionJobRunner instance for class - " + ingestionJobRunnerClassName, e);
        }
        ingestionJobRunner.init(spec);
        try {
            ingestionJobRunner.run();
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception during running - " + ingestionJobRunnerClassName, e);
        }
    }

    public static enum PinotIngestionJobType {
        SegmentCreation,
        SegmentTarPush,
        SegmentUriPush,
        SegmentMetadataPush,
        SegmentCreationAndTarPush,
        SegmentCreationAndUriPush,
        SegmentCreationAndMetadataPush;

        private static final Map<String, PinotIngestionJobType> VALUE_MAP;

        @JsonCreator
        public static PinotIngestionJobType fromString(String name) {
            PinotIngestionJobType jobType = VALUE_MAP.get(name.toLowerCase());
            if (jobType == null) {
                throw new IllegalArgumentException("No enum constant for: " + name);
            }
            return jobType;
        }

        static {
            VALUE_MAP = new HashMap<String, PinotIngestionJobType>();
            for (PinotIngestionJobType jobType : PinotIngestionJobType.values()) {
                VALUE_MAP.put(jobType.name().toLowerCase(), jobType);
            }
        }
    }
}

