/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader;

import com.google.common.base.Verify;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.Slice;
import io.trino.parquet.DataPage;
import io.trino.parquet.DataPageV1;
import io.trino.parquet.DataPageV2;
import io.trino.parquet.DictionaryPage;
import io.trino.parquet.ParquetCorruptionException;
import io.trino.parquet.ParquetTypeUtils;
import io.trino.parquet.reader.ColumnChunkDescriptor;
import io.trino.parquet.reader.MetadataReader;
import io.trino.parquet.reader.PageReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.format.DataPageHeader;
import org.apache.parquet.format.DataPageHeaderV2;
import org.apache.parquet.format.DictionaryPageHeader;
import org.apache.parquet.format.PageHeader;
import org.apache.parquet.format.Util;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;

public class ParquetColumnChunk {
    private final Optional<String> fileCreatedBy;
    private final ColumnChunkDescriptor descriptor;
    private final List<Slice> slices;
    private int sliceIndex;
    private BasicSliceInput input;
    private final OffsetIndex offsetIndex;

    public ParquetColumnChunk(Optional<String> fileCreatedBy, ColumnChunkDescriptor descriptor, List<Slice> slices, OffsetIndex offsetIndex) {
        this.fileCreatedBy = Objects.requireNonNull(fileCreatedBy, "fileCreatedBy is null");
        this.descriptor = descriptor;
        this.slices = slices;
        this.sliceIndex = 0;
        this.input = slices.get(0).getInput();
        this.offsetIndex = offsetIndex;
    }

    private void advanceIfNecessary() {
        if (this.input.available() == 0) {
            ++this.sliceIndex;
            if (this.sliceIndex < this.slices.size()) {
                this.input = this.slices.get(this.sliceIndex).getInput();
            }
        }
    }

    protected PageHeader readPageHeader() throws IOException {
        Verify.verify((this.input.available() > 0 ? 1 : 0) != 0, (String)"Reached end of input unexpectedly", (Object[])new Object[0]);
        PageHeader pageHeader = Util.readPageHeader((InputStream)this.input);
        this.advanceIfNecessary();
        return pageHeader;
    }

    public PageReader readAllPages() throws IOException {
        LinkedList<DataPage> pages = new LinkedList<DataPage>();
        DictionaryPage dictionaryPage = null;
        long valueCount = 0L;
        int dataPageCount = 0;
        block5: while (this.hasMorePages(valueCount, dataPageCount)) {
            PageHeader pageHeader = this.readPageHeader();
            int uncompressedPageSize = pageHeader.getUncompressed_page_size();
            int compressedPageSize = pageHeader.getCompressed_page_size();
            switch (pageHeader.type) {
                case DICTIONARY_PAGE: {
                    if (dictionaryPage != null) {
                        throw new ParquetCorruptionException("%s has more than one dictionary page in column chunk", this.descriptor.getColumnDescriptor());
                    }
                    dictionaryPage = this.readDictionaryPage(pageHeader, uncompressedPageSize, compressedPageSize);
                    continue block5;
                }
                case DATA_PAGE: {
                    valueCount += this.readDataPageV1(pageHeader, uncompressedPageSize, compressedPageSize, pages, ParquetColumnChunk.getFirstRowIndex(dataPageCount, this.offsetIndex));
                    ++dataPageCount;
                    continue block5;
                }
                case DATA_PAGE_V2: {
                    valueCount += this.readDataPageV2(pageHeader, uncompressedPageSize, compressedPageSize, pages, ParquetColumnChunk.getFirstRowIndex(dataPageCount, this.offsetIndex));
                    ++dataPageCount;
                    continue block5;
                }
            }
            this.input.skip((long)compressedPageSize);
            this.advanceIfNecessary();
        }
        return new PageReader(this.descriptor.getColumnChunkMetaData().getCodec(), pages, dictionaryPage, valueCount);
    }

    private boolean hasMorePages(long valuesCountReadSoFar, int dataPageCountReadSoFar) {
        if (this.offsetIndex == null) {
            return valuesCountReadSoFar < this.descriptor.getColumnChunkMetaData().getValueCount();
        }
        return dataPageCountReadSoFar < this.offsetIndex.getPageCount();
    }

    private Slice getSlice(int size) {
        Slice slice = this.input.readSlice(size);
        this.advanceIfNecessary();
        return slice;
    }

    private DictionaryPage readDictionaryPage(PageHeader pageHeader, int uncompressedPageSize, int compressedPageSize) {
        DictionaryPageHeader dicHeader = pageHeader.getDictionary_page_header();
        return new DictionaryPage(this.getSlice(compressedPageSize), uncompressedPageSize, dicHeader.getNum_values(), ParquetTypeUtils.getParquetEncoding(Encoding.valueOf((String)dicHeader.getEncoding().name())));
    }

    private long readDataPageV1(PageHeader pageHeader, int uncompressedPageSize, int compressedPageSize, List<DataPage> pages, OptionalLong firstRowIndex) {
        DataPageHeader dataHeaderV1 = pageHeader.getData_page_header();
        pages.add(new DataPageV1(this.getSlice(compressedPageSize), dataHeaderV1.getNum_values(), uncompressedPageSize, firstRowIndex, ParquetTypeUtils.getParquetEncoding(Encoding.valueOf((String)dataHeaderV1.getRepetition_level_encoding().name())), ParquetTypeUtils.getParquetEncoding(Encoding.valueOf((String)dataHeaderV1.getDefinition_level_encoding().name())), ParquetTypeUtils.getParquetEncoding(Encoding.valueOf((String)dataHeaderV1.getEncoding().name()))));
        return dataHeaderV1.getNum_values();
    }

    private long readDataPageV2(PageHeader pageHeader, int uncompressedPageSize, int compressedPageSize, List<DataPage> pages, OptionalLong firstRowIndex) {
        DataPageHeaderV2 dataHeaderV2 = pageHeader.getData_page_header_v2();
        int dataSize = compressedPageSize - dataHeaderV2.getRepetition_levels_byte_length() - dataHeaderV2.getDefinition_levels_byte_length();
        pages.add(new DataPageV2(dataHeaderV2.getNum_rows(), dataHeaderV2.getNum_nulls(), dataHeaderV2.getNum_values(), this.getSlice(dataHeaderV2.getRepetition_levels_byte_length()), this.getSlice(dataHeaderV2.getDefinition_levels_byte_length()), ParquetTypeUtils.getParquetEncoding(Encoding.valueOf((String)dataHeaderV2.getEncoding().name())), this.getSlice(dataSize), uncompressedPageSize, firstRowIndex, MetadataReader.readStats(this.fileCreatedBy, Optional.ofNullable(dataHeaderV2.getStatistics()), this.descriptor.getColumnDescriptor().getPrimitiveType()), dataHeaderV2.isIs_compressed()));
        return dataHeaderV2.getNum_values();
    }

    private static OptionalLong getFirstRowIndex(int pageIndex, OffsetIndex offsetIndex) {
        return offsetIndex == null ? OptionalLong.empty() : OptionalLong.of(offsetIndex.getFirstRowIndex(pageIndex));
    }
}

