/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.google.common.base.Preconditions;
import io.trino.connector.CatalogHandle;
import javax.validation.constraints.NotNull;

public interface CatalogServiceProvider<T> {
    public static <T> CatalogServiceProvider<T> fail() {
        return CatalogServiceProvider.fail("Not supported");
    }

    public static <T> CatalogServiceProvider<T> fail(String message) {
        return catalogName -> {
            throw new IllegalStateException(message);
        };
    }

    public static <T> CatalogServiceProvider<T> singleton(CatalogHandle catalogHandle, T value) {
        return catalogName -> {
            Preconditions.checkArgument((boolean)catalogName.equals(catalogHandle));
            return value;
        };
    }

    @NotNull
    public T getService(CatalogHandle var1);
}

