/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.google.common.base.Preconditions;
import io.airlift.node.NodeInfo;
import io.trino.connector.CatalogConnector;
import io.trino.connector.CatalogFactory;
import io.trino.connector.CatalogHandle;
import io.trino.connector.CatalogProperties;
import io.trino.connector.ConnectorAwareNodeManager;
import io.trino.connector.ConnectorContextInstance;
import io.trino.connector.ConnectorServices;
import io.trino.connector.InternalMetadataProvider;
import io.trino.connector.informationschema.InformationSchemaConnector;
import io.trino.connector.system.CoordinatorSystemTablesProvider;
import io.trino.connector.system.StaticSystemTablesProvider;
import io.trino.connector.system.SystemConnector;
import io.trino.connector.system.SystemTablesProvider;
import io.trino.execution.scheduler.NodeSchedulerConfig;
import io.trino.metadata.HandleResolver;
import io.trino.metadata.InternalNodeManager;
import io.trino.metadata.Metadata;
import io.trino.security.AccessControl;
import io.trino.server.PluginClassLoader;
import io.trino.spi.PageIndexerFactory;
import io.trino.spi.PageSorter;
import io.trino.spi.VersionEmbedder;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.type.TypeManager;
import io.trino.transaction.TransactionId;
import io.trino.transaction.TransactionManager;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public class DefaultCatalogFactory
implements CatalogFactory {
    private final Metadata metadata;
    private final AccessControl accessControl;
    private final HandleResolver handleResolver;
    private final InternalNodeManager nodeManager;
    private final PageSorter pageSorter;
    private final PageIndexerFactory pageIndexerFactory;
    private final NodeInfo nodeInfo;
    private final VersionEmbedder versionEmbedder;
    private final TransactionManager transactionManager;
    private final TypeManager typeManager;
    private final boolean schedulerIncludeCoordinator;
    private final ConcurrentMap<String, InternalConnectorFactory> connectorFactories = new ConcurrentHashMap<String, InternalConnectorFactory>();

    @Inject
    public DefaultCatalogFactory(Metadata metadata, AccessControl accessControl, HandleResolver handleResolver, InternalNodeManager nodeManager, PageSorter pageSorter, PageIndexerFactory pageIndexerFactory, NodeInfo nodeInfo, VersionEmbedder versionEmbedder, TransactionManager transactionManager, TypeManager typeManager, NodeSchedulerConfig nodeSchedulerConfig) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.handleResolver = Objects.requireNonNull(handleResolver, "handleResolver is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.pageSorter = Objects.requireNonNull(pageSorter, "pageSorter is null");
        this.pageIndexerFactory = Objects.requireNonNull(pageIndexerFactory, "pageIndexerFactory is null");
        this.nodeInfo = Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        this.versionEmbedder = Objects.requireNonNull(versionEmbedder, "versionEmbedder is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.schedulerIncludeCoordinator = nodeSchedulerConfig.isIncludeCoordinator();
    }

    @Override
    public synchronized void addConnectorFactory(ConnectorFactory connectorFactory, Function<CatalogHandle, ClassLoader> duplicatePluginClassLoaderFactory) {
        InternalConnectorFactory existingConnectorFactory = this.connectorFactories.putIfAbsent(connectorFactory.getName(), new InternalConnectorFactory(connectorFactory, duplicatePluginClassLoaderFactory));
        Preconditions.checkArgument((existingConnectorFactory == null ? 1 : 0) != 0, (String)"Connector '%s' is already registered", (Object)connectorFactory.getName());
    }

    @Override
    public CatalogConnector createCatalog(CatalogProperties catalogProperties) {
        Objects.requireNonNull(catalogProperties, "catalogProperties is null");
        InternalConnectorFactory factory = (InternalConnectorFactory)this.connectorFactories.get(catalogProperties.getConnectorName());
        Preconditions.checkArgument((factory != null ? 1 : 0) != 0, (String)"No factory for connector '%s'.  Available factories: %s", (Object)catalogProperties.getConnectorName(), this.connectorFactories.keySet());
        CatalogClassLoaderSupplier duplicatePluginClassLoaderFactory = new CatalogClassLoaderSupplier(catalogProperties.getCatalogHandle(), factory.getDuplicatePluginClassLoaderFactory(), this.handleResolver);
        Connector connector = this.createConnector(catalogProperties.getCatalogHandle().getCatalogName(), catalogProperties.getCatalogHandle(), factory.getConnectorFactory(), duplicatePluginClassLoaderFactory, catalogProperties.getProperties());
        return this.createCatalog(catalogProperties.getCatalogHandle(), factory.getConnectorFactory().getName(), connector, duplicatePluginClassLoaderFactory::destroy, Optional.of(catalogProperties));
    }

    @Override
    public CatalogConnector createCatalog(CatalogHandle catalogHandle, String connectorName, Connector connector) {
        return this.createCatalog(catalogHandle, connectorName, connector, () -> {}, Optional.empty());
    }

    private CatalogConnector createCatalog(CatalogHandle catalogHandle, String connectorName, Connector connector, Runnable destroy, Optional<CatalogProperties> catalogProperties) {
        ConnectorServices catalogConnector = new ConnectorServices(catalogHandle, connector, destroy);
        ConnectorServices informationSchemaConnector = new ConnectorServices(CatalogHandle.createInformationSchemaCatalogHandle(catalogHandle), new InformationSchemaConnector(catalogHandle.getCatalogName(), this.nodeManager, this.metadata, this.accessControl), () -> {});
        SystemTablesProvider systemTablesProvider = this.nodeManager.getCurrentNode().isCoordinator() ? new CoordinatorSystemTablesProvider(this.transactionManager, this.metadata, catalogHandle.getCatalogName(), new StaticSystemTablesProvider(catalogConnector.getSystemTables())) : new StaticSystemTablesProvider(catalogConnector.getSystemTables());
        ConnectorServices systemConnector = new ConnectorServices(CatalogHandle.createSystemTablesCatalogHandle(catalogHandle), new SystemConnector(this.nodeManager, systemTablesProvider, transactionId -> this.transactionManager.getConnectorTransaction((TransactionId)transactionId, catalogHandle)), () -> {});
        return new CatalogConnector(catalogHandle, connectorName, catalogConnector, informationSchemaConnector, systemConnector, catalogProperties);
    }

    private Connector createConnector(String catalogName, CatalogHandle catalogHandle, ConnectorFactory connectorFactory, Supplier<ClassLoader> duplicatePluginClassLoaderFactory, Map<String, String> properties) {
        ConnectorContextInstance context = new ConnectorContextInstance(new ConnectorAwareNodeManager(this.nodeManager, this.nodeInfo.getEnvironment(), catalogHandle, this.schedulerIncludeCoordinator), this.versionEmbedder, this.typeManager, new InternalMetadataProvider(this.metadata, this.typeManager), this.pageSorter, this.pageIndexerFactory, duplicatePluginClassLoaderFactory);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(connectorFactory.getClass().getClassLoader());){
            Connector connector = connectorFactory.create(catalogName, properties, (ConnectorContext)context);
            return connector;
        }
    }

    private static class InternalConnectorFactory {
        private final ConnectorFactory connectorFactory;
        private final Function<CatalogHandle, ClassLoader> duplicatePluginClassLoaderFactory;

        public InternalConnectorFactory(ConnectorFactory connectorFactory, Function<CatalogHandle, ClassLoader> duplicatePluginClassLoaderFactory) {
            this.connectorFactory = connectorFactory;
            this.duplicatePluginClassLoaderFactory = duplicatePluginClassLoaderFactory;
        }

        public ConnectorFactory getConnectorFactory() {
            return this.connectorFactory;
        }

        public Function<CatalogHandle, ClassLoader> getDuplicatePluginClassLoaderFactory() {
            return this.duplicatePluginClassLoaderFactory;
        }

        public String toString() {
            return this.connectorFactory.getName();
        }
    }

    private static class CatalogClassLoaderSupplier
    implements Supplier<ClassLoader> {
        private final CatalogHandle catalogHandle;
        private final Function<CatalogHandle, ClassLoader> duplicatePluginClassLoaderFactory;
        private final HandleResolver handleResolver;
        @GuardedBy(value="this")
        private boolean destroyed;
        @GuardedBy(value="this")
        private ClassLoader classLoader;

        public CatalogClassLoaderSupplier(CatalogHandle catalogHandle, Function<CatalogHandle, ClassLoader> duplicatePluginClassLoaderFactory, HandleResolver handleResolver) {
            this.catalogHandle = Objects.requireNonNull(catalogHandle, "catalogHandle is null");
            this.duplicatePluginClassLoaderFactory = Objects.requireNonNull(duplicatePluginClassLoaderFactory, "duplicatePluginClassLoaderFactory is null");
            this.handleResolver = Objects.requireNonNull(handleResolver, "handleResolver is null");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClassLoader get() {
            ClassLoader classLoader = this.duplicatePluginClassLoaderFactory.apply(this.catalogHandle);
            CatalogClassLoaderSupplier catalogClassLoaderSupplier = this;
            synchronized (catalogClassLoaderSupplier) {
                Preconditions.checkState((this.classLoader == null ? 1 : 0) != 0, (Object)("class loader is already a duplicated for catalog " + this.catalogHandle));
                Preconditions.checkState((!this.destroyed ? 1 : 0) != 0, (Object)"catalog has been shutdown");
                this.classLoader = classLoader;
            }
            if (classLoader instanceof PluginClassLoader) {
                this.handleResolver.registerClassLoader((PluginClassLoader)classLoader);
            }
            return classLoader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            ClassLoader classLoader;
            CatalogClassLoaderSupplier catalogClassLoaderSupplier = this;
            synchronized (catalogClassLoaderSupplier) {
                Preconditions.checkState((!this.destroyed ? 1 : 0) != 0, (Object)"catalog has been shutdown");
                classLoader = this.classLoader;
                this.destroyed = true;
            }
            if (classLoader instanceof PluginClassLoader) {
                this.handleResolver.unregisterClassLoader((PluginClassLoader)classLoader);
            }
        }
    }
}

