/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import io.airlift.configuration.ConfigurationLoader;
import io.airlift.log.Logger;
import io.trino.connector.CatalogHandle;
import io.trino.connector.CatalogProperties;
import io.trino.connector.CatalogStore;
import io.trino.connector.StaticCatalogManagerConfig;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

public class FileCatalogStore
implements CatalogStore {
    private static final Logger log = Logger.get(FileCatalogStore.class);
    private final List<CatalogProperties> catalogs;

    @Inject
    public FileCatalogStore(StaticCatalogManagerConfig config) {
        List disabledCatalogs = (List)MoreObjects.firstNonNull(config.getDisabledCatalogs(), (Object)ImmutableList.of());
        ImmutableList.Builder catalogProperties = ImmutableList.builder();
        for (File file : FileCatalogStore.listCatalogFiles(config.getCatalogConfigurationDir())) {
            HashMap properties;
            String catalogName = Files.getNameWithoutExtension((String)file.getName());
            Preconditions.checkArgument((!catalogName.equals("system") ? 1 : 0) != 0, (Object)"Catalog name SYSTEM is reserved for internal usage");
            if (disabledCatalogs.contains(catalogName)) {
                log.info("Skipping disabled catalog %s", new Object[]{catalogName});
                continue;
            }
            try {
                properties = new HashMap(ConfigurationLoader.loadPropertiesFrom((String)file.getPath()));
            }
            catch (IOException e) {
                throw new UncheckedIOException("Error reading catalog property file " + file, e);
            }
            String connectorName = (String)properties.remove("connector.name");
            Preconditions.checkState((connectorName != null ? 1 : 0) != 0, (String)"Catalog configuration %s does not contain 'connector.name'", (Object)file.getAbsoluteFile());
            catalogProperties.add((Object)new CatalogProperties(CatalogHandle.createRootCatalogHandle(catalogName), connectorName, (Map<String, String>)ImmutableMap.copyOf(properties)));
        }
        this.catalogs = catalogProperties.build();
    }

    @Override
    public Collection<CatalogProperties> getCatalogs() {
        return this.catalogs;
    }

    private static List<File> listCatalogFiles(File catalogsDirectory) {
        if (catalogsDirectory == null || !catalogsDirectory.isDirectory()) {
            return ImmutableList.of();
        }
        File[] files = catalogsDirectory.listFiles();
        if (files == null) {
            return ImmutableList.of();
        }
        return (List)Arrays.stream(files).filter(File::isFile).filter(file -> file.getName().endsWith(".properties")).collect(ImmutableList.toImmutableList());
    }
}

