/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.google.common.collect.ImmutableList;
import io.trino.FullConnectorSession;
import io.trino.Session;
import io.trino.metadata.MaterializedViewDefinition;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.metadata.ViewColumn;
import io.trino.metadata.ViewDefinition;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnSchema;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableSchema;
import io.trino.spi.connector.MetadataProvider;
import io.trino.spi.type.TypeManager;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class InternalMetadataProvider
implements MetadataProvider {
    private final Metadata metadata;
    private final TypeManager typeManager;

    public InternalMetadataProvider(Metadata metadata, TypeManager typeManager) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public Optional<ConnectorTableSchema> getRelationMetadata(ConnectorSession connectorSession, CatalogSchemaTableName tableName) {
        QualifiedObjectName qualifiedName;
        Session session = ((FullConnectorSession)connectorSession).getSession();
        Optional<MaterializedViewDefinition> materializedView = this.metadata.getMaterializedView(session, qualifiedName = new QualifiedObjectName(tableName.getCatalogName(), tableName.getSchemaTableName().getSchemaName(), tableName.getSchemaTableName().getTableName()));
        if (materializedView.isPresent()) {
            return Optional.of(new ConnectorTableSchema(tableName.getSchemaTableName(), this.toColumnSchema(materializedView.get().getColumns())));
        }
        Optional<ViewDefinition> view = this.metadata.getView(session, qualifiedName);
        if (view.isPresent()) {
            return Optional.of(new ConnectorTableSchema(tableName.getSchemaTableName(), this.toColumnSchema(view.get().getColumns())));
        }
        Optional<TableHandle> tableHandle = this.metadata.getTableHandle(session, qualifiedName);
        if (tableHandle.isPresent()) {
            return Optional.of(this.metadata.getTableSchema(session, tableHandle.get()).getTableSchema());
        }
        return Optional.empty();
    }

    private List<ColumnSchema> toColumnSchema(List<ViewColumn> viewColumns) {
        return (List)viewColumns.stream().map(viewColumn -> ColumnSchema.builder().setName(viewColumn.getName()).setType(this.typeManager.getType(viewColumn.getType())).build()).collect(ImmutableList.toImmutableList());
    }
}

