/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import io.airlift.configuration.ConfigurationLoader;
import io.airlift.log.Logger;
import io.trino.Session;
import io.trino.connector.CatalogConnector;
import io.trino.connector.CatalogFactory;
import io.trino.connector.CatalogHandle;
import io.trino.connector.CatalogProperties;
import io.trino.connector.ConnectorServices;
import io.trino.connector.ConnectorServicesProvider;
import io.trino.connector.StaticCatalogManagerConfig;
import io.trino.connector.system.GlobalSystemConnector;
import io.trino.metadata.Catalog;
import io.trino.metadata.CatalogManager;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public class StaticCatalogManager
implements CatalogManager,
ConnectorServicesProvider {
    private static final Logger log = Logger.get(StaticCatalogManager.class);
    private final CatalogFactory catalogFactory;
    private final List<CatalogProperties> catalogProperties;
    private final ConcurrentMap<String, CatalogConnector> catalogs = new ConcurrentHashMap<String, CatalogConnector>();
    private final AtomicReference<State> state = new AtomicReference<State>(State.CREATED);

    @Inject
    public StaticCatalogManager(CatalogFactory catalogFactory, StaticCatalogManagerConfig config) {
        this.catalogFactory = Objects.requireNonNull(catalogFactory, "catalogFactory is null");
        List disabledCatalogs = (List)MoreObjects.firstNonNull(config.getDisabledCatalogs(), (Object)ImmutableList.of());
        ImmutableList.Builder catalogProperties = ImmutableList.builder();
        for (File file : StaticCatalogManager.listCatalogFiles(config.getCatalogConfigurationDir())) {
            HashMap properties;
            String catalogName = Files.getNameWithoutExtension((String)file.getName());
            Preconditions.checkArgument((!catalogName.equals("system") ? 1 : 0) != 0, (Object)"Catalog name SYSTEM is reserved for internal usage");
            if (disabledCatalogs.contains(catalogName)) {
                log.info("Skipping disabled catalog %s", new Object[]{catalogName});
                continue;
            }
            try {
                properties = new HashMap(ConfigurationLoader.loadPropertiesFrom((String)file.getPath()));
            }
            catch (IOException e) {
                throw new UncheckedIOException("Error reading catalog property file " + file, e);
            }
            String connectorName = (String)properties.remove("connector.name");
            Preconditions.checkState((connectorName != null ? 1 : 0) != 0, (String)"Catalog configuration %s does not contain connector.name", (Object)file.getAbsoluteFile());
            catalogProperties.add((Object)new CatalogProperties(CatalogHandle.createRootCatalogHandle(catalogName), connectorName, (Map<String, String>)ImmutableMap.copyOf(properties)));
        }
        this.catalogProperties = catalogProperties.build();
    }

    private static List<File> listCatalogFiles(File catalogsDirectory) {
        if (catalogsDirectory == null || !catalogsDirectory.isDirectory()) {
            return ImmutableList.of();
        }
        File[] files = catalogsDirectory.listFiles();
        if (files == null) {
            return ImmutableList.of();
        }
        return (List)Arrays.stream(files).filter(File::isFile).filter(file -> file.getName().endsWith(".properties")).collect(ImmutableList.toImmutableList());
    }

    @PreDestroy
    public void stop() {
        if (this.state.getAndSet(State.STOPPED) == State.STOPPED) {
            return;
        }
        for (CatalogConnector connector : this.catalogs.values()) {
            connector.shutdown();
        }
        this.catalogs.clear();
    }

    @Override
    public void loadInitialCatalogs() {
        if (!this.state.compareAndSet(State.CREATED, State.INITIALIZED)) {
            return;
        }
        for (CatalogProperties catalog : this.catalogProperties) {
            String catalogName = catalog.getCatalogHandle().getCatalogName();
            log.info("-- Loading catalog %s --", new Object[]{catalogName});
            CatalogConnector newCatalog = this.catalogFactory.createCatalog(catalog);
            this.catalogs.put(catalogName, newCatalog);
            log.info("-- Added catalog %s using connector %s --", new Object[]{catalogName, catalog.getConnectorName()});
        }
    }

    @Override
    public Set<String> getCatalogNames() {
        return ImmutableSet.copyOf(this.catalogs.keySet());
    }

    @Override
    public Optional<Catalog> getCatalog(String catalogName) {
        return Optional.ofNullable((CatalogConnector)this.catalogs.get(catalogName)).map(CatalogConnector::getCatalog);
    }

    @Override
    public void ensureCatalogsLoaded(Session session, List<CatalogProperties> catalogs) {
        List missingCatalogs = (List)catalogs.stream().filter(catalog -> !this.catalogs.containsKey(catalog.getCatalogHandle().getCatalogName())).collect(ImmutableList.toImmutableList());
        if (!missingCatalogs.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.CATALOG_NOT_AVAILABLE, "Missing catalogs: " + missingCatalogs);
        }
    }

    @Override
    public Optional<CatalogProperties> getCatalogProperties(CatalogHandle catalogHandle) {
        return Optional.empty();
    }

    @Override
    public ConnectorServices getConnectorServices(CatalogHandle catalogHandle) {
        CatalogConnector catalogConnector = (CatalogConnector)this.catalogs.get(catalogHandle.getCatalogName());
        Preconditions.checkArgument((catalogConnector != null ? 1 : 0) != 0, (String)"No catalog '%s'", (Object)catalogHandle.getCatalogName());
        return catalogConnector.getMaterializedConnector(catalogHandle.getType());
    }

    public void registerGlobalSystemConnector(GlobalSystemConnector connector) {
        Objects.requireNonNull(connector, "connector is null");
        CatalogConnector catalog = this.catalogFactory.createCatalog(GlobalSystemConnector.CATALOG_HANDLE, "system", connector);
        if (this.catalogs.putIfAbsent("system", catalog) != null) {
            throw new IllegalStateException("Global system catalog already registered");
        }
    }

    @Override
    public void createCatalog(String catalogName, String connectorName, Map<String, String> properties) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Create catalog is not supported by the static catalog manager");
    }

    private static enum State {
        CREATED,
        INITIALIZED,
        STOPPED;

    }
}

