/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.connector.CatalogHandle;
import io.trino.connector.system.GlobalSystemTransactionHandle;
import io.trino.metadata.CatalogInfo;
import io.trino.metadata.MetadataUtil;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.InMemoryRecordSet;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.transaction.TransactionId;
import io.trino.transaction.TransactionManager;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

abstract class AbstractPropertiesSystemTable
implements SystemTable {
    private final ConnectorTableMetadata tableMetadata;
    private final TransactionManager transactionManager;
    private final Function<CatalogHandle, Collection<PropertyMetadata<?>>> catalogProperties;

    protected AbstractPropertiesSystemTable(String tableName, TransactionManager transactionManager, Function<CatalogHandle, Collection<PropertyMetadata<?>>> catalogProperties) {
        this.tableMetadata = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(new SchemaTableName("metadata", tableName)).column("catalog_name", (Type)VarcharType.createUnboundedVarcharType()).column("property_name", (Type)VarcharType.createUnboundedVarcharType()).column("default_value", (Type)VarcharType.createUnboundedVarcharType()).column("type", (Type)VarcharType.createUnboundedVarcharType()).column("description", (Type)VarcharType.createUnboundedVarcharType()).build();
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.catalogProperties = Objects.requireNonNull(catalogProperties, "catalogProperties is null");
    }

    public final SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public final ConnectorTableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public final RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        TransactionId transactionId = ((GlobalSystemTransactionHandle)transactionHandle).getTransactionId();
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)this.tableMetadata);
        List catalogInfos = (List)this.transactionManager.getCatalogs(transactionId).stream().sorted(Comparator.comparing(CatalogInfo::getCatalogName)).collect(ImmutableList.toImmutableList());
        for (CatalogInfo catalogInfo : catalogInfos) {
            this.catalogProperties.apply(catalogInfo.getCatalogHandle()).stream().sorted(Comparator.comparing(PropertyMetadata::getName)).forEach(propertyMetadata -> table.addRow(new Object[]{catalogInfo.getCatalogName(), propertyMetadata.getName(), MoreObjects.firstNonNull((Object)propertyMetadata.getDefaultValue(), (Object)"").toString(), propertyMetadata.getSqlType().toString(), propertyMetadata.getDescription()}));
        }
        return table.build().cursor();
    }
}

