/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system;

import com.google.common.collect.ImmutableSet;
import io.trino.connector.CatalogHandle;
import io.trino.connector.system.GlobalSystemTransactionHandle;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.transaction.IsolationLevel;
import io.trino.transaction.InternalConnector;
import io.trino.transaction.TransactionId;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;

public class GlobalSystemConnector
implements InternalConnector {
    public static final String NAME = "system";
    public static final CatalogHandle CATALOG_HANDLE = CatalogHandle.createRootCatalogHandle("system");
    private final Set<SystemTable> systemTables;
    private final Set<Procedure> procedures;

    @Inject
    public GlobalSystemConnector(Set<SystemTable> systemTables, Set<Procedure> procedures) {
        this.systemTables = ImmutableSet.copyOf((Collection)Objects.requireNonNull(systemTables, "systemTables is null"));
        this.procedures = ImmutableSet.copyOf((Collection)Objects.requireNonNull(procedures, "procedures is null"));
    }

    @Override
    public ConnectorTransactionHandle beginTransaction(TransactionId transactionId, IsolationLevel isolationLevel, boolean readOnly) {
        return new GlobalSystemTransactionHandle(transactionId);
    }

    public ConnectorMetadata getMetadata(ConnectorSession session, ConnectorTransactionHandle transactionHandle) {
        return new ConnectorMetadata(){};
    }

    public Set<SystemTable> getSystemTables() {
        return this.systemTables;
    }

    public Set<Procedure> getProcedures() {
        return this.procedures;
    }
}

