/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.execution.scheduler.NodeSchedulerConfig;
import io.trino.metadata.InternalNode;
import io.trino.metadata.InternalNodeManager;
import io.trino.operator.RetryPolicy;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntSupplier;
import javax.inject.Inject;

public class TaskCountEstimator {
    private final IntSupplier numberOfNodes;

    @Inject
    public TaskCountEstimator(NodeSchedulerConfig nodeSchedulerConfig, InternalNodeManager nodeManager) {
        boolean schedulerIncludeCoordinator = nodeSchedulerConfig.isIncludeCoordinator();
        Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.numberOfNodes = () -> {
            Set<InternalNode> activeNodes = nodeManager.getAllNodes().getActiveNodes();
            if (schedulerIncludeCoordinator) {
                return activeNodes.size();
            }
            return Math.toIntExact(activeNodes.stream().filter(node -> !node.isCoordinator()).count());
        };
    }

    public TaskCountEstimator(IntSupplier numberOfNodes) {
        this.numberOfNodes = Objects.requireNonNull(numberOfNodes, "numberOfNodes is null");
    }

    public int estimateSourceDistributedTaskCount(Session session) {
        Integer costEstimationWorkerCount = SystemSessionProperties.getCostEstimationWorkerCount(session);
        if (costEstimationWorkerCount != null) {
            return costEstimationWorkerCount;
        }
        return this.numberOfNodes.getAsInt();
    }

    public int estimateHashedTaskCount(Session session) {
        int partitionCount = SystemSessionProperties.getRetryPolicy(session) == RetryPolicy.TASK ? SystemSessionProperties.getFaultTolerantExecutionPartitionCount(session) : SystemSessionProperties.getHashPartitionCount(session);
        return Math.min(this.estimateSourceDistributedTaskCount(session), partitionCount);
    }
}

