/*
 * Decompiled with CFR 0.152.
 */
package io.trino.exchange;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.airlift.slice.SizeOf;
import io.trino.exchange.ExchangeInput;
import io.trino.execution.TaskId;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class DirectExchangeInput
implements ExchangeInput {
    private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(DirectExchangeInput.class).instanceSize());
    private final TaskId taskId;
    private final String location;

    @JsonCreator
    public DirectExchangeInput(@JsonProperty(value="taskId") TaskId taskId, @JsonProperty(value="location") String location) {
        this.taskId = Objects.requireNonNull(taskId, "taskId is null");
        this.location = Objects.requireNonNull(location, "location is null");
    }

    @JsonProperty
    public TaskId getTaskId() {
        return this.taskId;
    }

    @JsonProperty
    public String getLocation() {
        return this.location;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("taskId", (Object)this.taskId).add("location", (Object)this.location).toString();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.taskId.getRetainedSizeInBytes() + SizeOf.estimatedSizeOf((String)this.location);
    }
}

