/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.operator.BlockedReason;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class BasicStageStats {
    public static final BasicStageStats EMPTY_STAGE_STATS = new BasicStageStats(false, 0, 0, 0, 0, 0, DataSize.ofBytes((long)0L), 0L, new Duration(0.0, TimeUnit.MILLISECONDS), DataSize.ofBytes((long)0L), 0L, DataSize.ofBytes((long)0L), 0L, 0L, 0L, DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), false, (Set<BlockedReason>)ImmutableSet.of(), OptionalDouble.empty());
    private final boolean isScheduled;
    private final int failedTasks;
    private final int totalDrivers;
    private final int queuedDrivers;
    private final int runningDrivers;
    private final int completedDrivers;
    private final DataSize physicalInputDataSize;
    private final long physicalInputPositions;
    private final Duration physicalInputReadTime;
    private final DataSize internalNetworkInputDataSize;
    private final long internalNetworkInputPositions;
    private final DataSize rawInputDataSize;
    private final long rawInputPositions;
    private final long cumulativeUserMemory;
    private final long failedCumulativeUserMemory;
    private final DataSize userMemoryReservation;
    private final DataSize totalMemoryReservation;
    private final Duration totalCpuTime;
    private final Duration failedCpuTime;
    private final Duration totalScheduledTime;
    private final Duration failedScheduledTime;
    private final boolean fullyBlocked;
    private final Set<BlockedReason> blockedReasons;
    private final OptionalDouble progressPercentage;

    public BasicStageStats(boolean isScheduled, int failedTasks, int totalDrivers, int queuedDrivers, int runningDrivers, int completedDrivers, DataSize physicalInputDataSize, long physicalInputPositions, Duration physicalInputReadTime, DataSize internalNetworkInputDataSize, long internalNetworkInputPositions, DataSize rawInputDataSize, long rawInputPositions, long cumulativeUserMemory, long failedCumulativeUserMemory, DataSize userMemoryReservation, DataSize totalMemoryReservation, Duration totalCpuTime, Duration failedCpuTime, Duration totalScheduledTime, Duration failedScheduledTime, boolean fullyBlocked, Set<BlockedReason> blockedReasons, OptionalDouble progressPercentage) {
        this.isScheduled = isScheduled;
        this.failedTasks = failedTasks;
        this.totalDrivers = totalDrivers;
        this.queuedDrivers = queuedDrivers;
        this.runningDrivers = runningDrivers;
        this.completedDrivers = completedDrivers;
        this.physicalInputDataSize = Objects.requireNonNull(physicalInputDataSize, "physicalInputDataSize is null");
        this.physicalInputPositions = physicalInputPositions;
        this.physicalInputReadTime = Objects.requireNonNull(physicalInputReadTime, "physicalInputReadTime is null");
        this.internalNetworkInputDataSize = Objects.requireNonNull(internalNetworkInputDataSize, "internalNetworkInputDataSize is null");
        this.internalNetworkInputPositions = internalNetworkInputPositions;
        this.rawInputDataSize = Objects.requireNonNull(rawInputDataSize, "rawInputDataSize is null");
        this.rawInputPositions = rawInputPositions;
        this.cumulativeUserMemory = cumulativeUserMemory;
        this.failedCumulativeUserMemory = failedCumulativeUserMemory;
        this.userMemoryReservation = Objects.requireNonNull(userMemoryReservation, "userMemoryReservation is null");
        this.totalMemoryReservation = Objects.requireNonNull(totalMemoryReservation, "totalMemoryReservation is null");
        this.totalCpuTime = Objects.requireNonNull(totalCpuTime, "totalCpuTime is null");
        this.failedCpuTime = Objects.requireNonNull(failedCpuTime, "failedCpuTime is null");
        this.totalScheduledTime = Objects.requireNonNull(totalScheduledTime, "totalScheduledTime is null");
        this.failedScheduledTime = Objects.requireNonNull(failedScheduledTime, "failedScheduledTime is null");
        this.fullyBlocked = fullyBlocked;
        this.blockedReasons = ImmutableSet.copyOf((Collection)Objects.requireNonNull(blockedReasons, "blockedReasons is null"));
        this.progressPercentage = Objects.requireNonNull(progressPercentage, "progressPercentage is null");
    }

    public boolean isScheduled() {
        return this.isScheduled;
    }

    public int getFailedTasks() {
        return this.failedTasks;
    }

    public int getTotalDrivers() {
        return this.totalDrivers;
    }

    public int getQueuedDrivers() {
        return this.queuedDrivers;
    }

    public int getRunningDrivers() {
        return this.runningDrivers;
    }

    public int getCompletedDrivers() {
        return this.completedDrivers;
    }

    public DataSize getPhysicalInputDataSize() {
        return this.physicalInputDataSize;
    }

    public long getPhysicalInputPositions() {
        return this.physicalInputPositions;
    }

    public DataSize getInternalNetworkInputDataSize() {
        return this.internalNetworkInputDataSize;
    }

    public long getInternalNetworkInputPositions() {
        return this.internalNetworkInputPositions;
    }

    public DataSize getRawInputDataSize() {
        return this.rawInputDataSize;
    }

    public long getRawInputPositions() {
        return this.rawInputPositions;
    }

    public Duration getPhysicalInputReadTime() {
        return this.physicalInputReadTime;
    }

    public long getCumulativeUserMemory() {
        return this.cumulativeUserMemory;
    }

    public long getFailedCumulativeUserMemory() {
        return this.failedCumulativeUserMemory;
    }

    public DataSize getUserMemoryReservation() {
        return this.userMemoryReservation;
    }

    public DataSize getTotalMemoryReservation() {
        return this.totalMemoryReservation;
    }

    public Duration getTotalCpuTime() {
        return this.totalCpuTime;
    }

    public Duration getFailedCpuTime() {
        return this.failedCpuTime;
    }

    public Duration getTotalScheduledTime() {
        return this.totalScheduledTime;
    }

    public Duration getFailedScheduledTime() {
        return this.failedScheduledTime;
    }

    public boolean isFullyBlocked() {
        return this.fullyBlocked;
    }

    public Set<BlockedReason> getBlockedReasons() {
        return this.blockedReasons;
    }

    public OptionalDouble getProgressPercentage() {
        return this.progressPercentage;
    }

    public static BasicStageStats aggregateBasicStageStats(Iterable<BasicStageStats> stages) {
        int failedTasks = 0;
        int totalDrivers = 0;
        int queuedDrivers = 0;
        int runningDrivers = 0;
        int completedDrivers = 0;
        long cumulativeUserMemory = 0L;
        long failedCumulativeUserMemory = 0L;
        long userMemoryReservation = 0L;
        long totalMemoryReservation = 0L;
        long totalScheduledTimeMillis = 0L;
        long failedScheduledTimeMillis = 0L;
        long totalCpuTime = 0L;
        long failedCpuTime = 0L;
        long physicalInputDataSize = 0L;
        long physicalInputPositions = 0L;
        long physicalInputReadTime = 0L;
        long internalNetworkInputDataSize = 0L;
        long internalNetworkInputPositions = 0L;
        long rawInputDataSize = 0L;
        long rawInputPositions = 0L;
        boolean isScheduled = true;
        boolean fullyBlocked = true;
        HashSet<BlockedReason> blockedReasons = new HashSet<BlockedReason>();
        for (BasicStageStats stageStats : stages) {
            failedTasks += stageStats.getFailedTasks();
            totalDrivers += stageStats.getTotalDrivers();
            queuedDrivers += stageStats.getQueuedDrivers();
            runningDrivers += stageStats.getRunningDrivers();
            completedDrivers += stageStats.getCompletedDrivers();
            cumulativeUserMemory += stageStats.getCumulativeUserMemory();
            failedCumulativeUserMemory += stageStats.getFailedCumulativeUserMemory();
            userMemoryReservation += stageStats.getUserMemoryReservation().toBytes();
            totalMemoryReservation += stageStats.getTotalMemoryReservation().toBytes();
            totalScheduledTimeMillis += stageStats.getTotalScheduledTime().roundTo(TimeUnit.MILLISECONDS);
            failedScheduledTimeMillis += stageStats.getFailedScheduledTime().roundTo(TimeUnit.MILLISECONDS);
            totalCpuTime += stageStats.getTotalCpuTime().roundTo(TimeUnit.MILLISECONDS);
            failedCpuTime += stageStats.getFailedCpuTime().roundTo(TimeUnit.MILLISECONDS);
            isScheduled &= stageStats.isScheduled();
            fullyBlocked &= stageStats.isFullyBlocked();
            blockedReasons.addAll(stageStats.getBlockedReasons());
            physicalInputDataSize += stageStats.getPhysicalInputDataSize().toBytes();
            physicalInputPositions += stageStats.getPhysicalInputPositions();
            physicalInputReadTime += stageStats.getPhysicalInputReadTime().roundTo(TimeUnit.MILLISECONDS);
            internalNetworkInputDataSize += stageStats.getInternalNetworkInputDataSize().toBytes();
            internalNetworkInputPositions += stageStats.getInternalNetworkInputPositions();
            rawInputDataSize += stageStats.getRawInputDataSize().toBytes();
            rawInputPositions += stageStats.getRawInputPositions();
        }
        OptionalDouble progressPercentage = OptionalDouble.empty();
        if (isScheduled && totalDrivers != 0) {
            progressPercentage = OptionalDouble.of(Math.min(100.0, (double)completedDrivers * 100.0 / (double)totalDrivers));
        }
        return new BasicStageStats(isScheduled, failedTasks, totalDrivers, queuedDrivers, runningDrivers, completedDrivers, DataSize.succinctBytes((long)physicalInputDataSize), physicalInputPositions, new Duration((double)physicalInputReadTime, TimeUnit.MILLISECONDS).convertToMostSuccinctTimeUnit(), DataSize.succinctBytes((long)internalNetworkInputDataSize), internalNetworkInputPositions, DataSize.succinctBytes((long)rawInputDataSize), rawInputPositions, cumulativeUserMemory, failedCumulativeUserMemory, DataSize.succinctBytes((long)userMemoryReservation), DataSize.succinctBytes((long)totalMemoryReservation), new Duration((double)totalCpuTime, TimeUnit.MILLISECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)failedCpuTime, TimeUnit.MILLISECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalScheduledTimeMillis, TimeUnit.MILLISECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)failedScheduledTimeMillis, TimeUnit.MILLISECONDS).convertToMostSuccinctTimeUnit(), fullyBlocked, blockedReasons, progressPercentage);
    }
}

