/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.connector.CatalogHandle;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.MaterializedViewDefinition;
import io.trino.metadata.MaterializedViewPropertyManager;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.ViewColumn;
import io.trino.security.AccessControl;
import io.trino.sql.ParameterUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.SqlFormatterUtil;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.AnalyzerFactory;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.tree.CreateMaterializedView;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class CreateMaterializedViewTask
implements DataDefinitionTask<CreateMaterializedView> {
    private final PlannerContext plannerContext;
    private final AccessControl accessControl;
    private final SqlParser sqlParser;
    private final AnalyzerFactory analyzerFactory;
    private final MaterializedViewPropertyManager materializedViewPropertyManager;

    @Inject
    public CreateMaterializedViewTask(PlannerContext plannerContext, AccessControl accessControl, SqlParser sqlParser, AnalyzerFactory analyzerFactory, MaterializedViewPropertyManager materializedViewPropertyManager) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.analyzerFactory = Objects.requireNonNull(analyzerFactory, "analyzerFactory is null");
        this.materializedViewPropertyManager = Objects.requireNonNull(materializedViewPropertyManager, "materializedViewPropertyManager is null");
    }

    @Override
    public String getName() {
        return "CREATE MATERIALIZED VIEW";
    }

    @Override
    public ListenableFuture<Void> execute(CreateMaterializedView statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Session session = stateMachine.getSession();
        QualifiedObjectName name = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName());
        Map<NodeRef<Parameter>, Expression> parameterLookup = ParameterUtils.parameterExtractor((Statement)statement, parameters);
        String sql = SqlFormatterUtil.getFormattedSql((Statement)statement.getQuery(), this.sqlParser);
        Analysis analysis = this.analyzerFactory.createAnalyzer(session, parameters, parameterLookup, stateMachine.getWarningCollector()).analyze((Statement)statement);
        List columns = (List)analysis.getOutputDescriptor((Node)statement.getQuery()).getVisibleFields().stream().map(field -> new ViewColumn(field.getName().get(), field.getType().getTypeId())).collect(ImmutableList.toImmutableList());
        String catalogName = name.getCatalogName();
        CatalogHandle catalogHandle = MetadataUtil.getRequiredCatalogHandle(this.plannerContext.getMetadata(), session, (Node)statement, catalogName);
        Map properties = this.materializedViewPropertyManager.getProperties(catalogName, catalogHandle, (Iterable)statement.getProperties(), session, this.plannerContext, this.accessControl, (Map)parameterLookup, true);
        MaterializedViewDefinition definition = new MaterializedViewDefinition(sql, session.getCatalog(), session.getSchema(), columns, statement.getComment(), session.getIdentity(), Optional.empty(), properties);
        this.accessControl.checkCanCreateMaterializedView(session.toSecurityContext(), name, properties);
        this.plannerContext.getMetadata().createMaterializedView(session, name, definition, statement.isReplace(), statement.isNotExists());
        stateMachine.setOutput(analysis.getTarget());
        stateMachine.setReferencedTables(analysis.getReferencedTables());
        return Futures.immediateVoidFuture();
    }
}

