/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Stream;

public enum TaskState {
    PLANNED(false),
    RUNNING(false),
    FLUSHING(false),
    FINISHED(true),
    CANCELED(true),
    ABORTED(true),
    FAILED(true);

    public static final Set<TaskState> TERMINAL_TASK_STATES;
    private final boolean doneState;

    private TaskState(boolean doneState) {
        this.doneState = doneState;
    }

    public boolean isDone() {
        return this.doneState;
    }

    static {
        TERMINAL_TASK_STATES = (Set)Stream.of(TaskState.values()).filter(TaskState::isDone).collect(ImmutableSet.toImmutableSet());
    }
}

