/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.execution.ForQueryExecution;
import io.trino.execution.QueryManagerConfig;
import io.trino.execution.scheduler.ArbitraryDistributionSplitAssigner;
import io.trino.execution.scheduler.EventDrivenTaskSource;
import io.trino.execution.scheduler.FaultTolerantPartitioningScheme;
import io.trino.execution.scheduler.HashDistributionSplitAssigner;
import io.trino.execution.scheduler.OutputDataSizeEstimate;
import io.trino.execution.scheduler.SingleDistributionSplitAssigner;
import io.trino.execution.scheduler.SplitAssigner;
import io.trino.metadata.InternalNode;
import io.trino.metadata.InternalNodeManager;
import io.trino.spi.HostAddress;
import io.trino.spi.exchange.Exchange;
import io.trino.sql.planner.MergePartitioningHandle;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.SplitSourceFactory;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.plan.RemoteSourceNode;
import io.trino.sql.planner.plan.TableWriterNode;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.LongConsumer;
import javax.inject.Inject;

public class EventDrivenTaskSourceFactory {
    private final SplitSourceFactory splitSourceFactory;
    private final Executor executor;
    private final InternalNodeManager nodeManager;
    private final int splitBatchSize;

    @Inject
    public EventDrivenTaskSourceFactory(SplitSourceFactory splitSourceFactory, @ForQueryExecution ExecutorService executor, InternalNodeManager nodeManager, QueryManagerConfig queryManagerConfig) {
        this(splitSourceFactory, (Executor)executor, nodeManager, Objects.requireNonNull(queryManagerConfig, "queryManagerConfig is null").getScheduleSplitBatchSize());
    }

    public EventDrivenTaskSourceFactory(SplitSourceFactory splitSourceFactory, Executor executor, InternalNodeManager nodeManager, int splitBatchSize) {
        this.splitSourceFactory = Objects.requireNonNull(splitSourceFactory, "splitSourceFactory is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.splitBatchSize = splitBatchSize;
    }

    public EventDrivenTaskSource create(EventDrivenTaskSource.Callback callback, Session session, PlanFragment fragment, Map<PlanFragmentId, Exchange> sourceExchanges, FaultTolerantPartitioningScheme sourcePartitioningScheme, LongConsumer getSplitTimeRecorder, Map<PlanNodeId, OutputDataSizeEstimate> outputDataSizeEstimates) {
        ImmutableMap.Builder remoteSources = ImmutableMap.builder();
        for (RemoteSourceNode remoteSource : fragment.getRemoteSourceNodes()) {
            for (PlanFragmentId sourceFragment : remoteSource.getSourceFragmentIds()) {
                remoteSources.put((Object)sourceFragment, (Object)remoteSource.getId());
            }
        }
        long targetPartitionSizeInBytes = SystemSessionProperties.getFaultTolerantExecutionTargetTaskInputSize(session).toBytes();
        long standardSplitSizeInBytes = targetPartitionSizeInBytes / (long)SystemSessionProperties.getFaultTolerantExecutionTargetTaskSplitCount(session);
        int maxTaskSplitCount = SystemSessionProperties.getFaultTolerantExecutionMaxTaskSplitCount(session);
        return new EventDrivenTaskSource(sourceExchanges, (Map<PlanFragmentId, PlanNodeId>)remoteSources.buildOrThrow(), () -> this.splitSourceFactory.createSplitSources(session, fragment), this.createSplitAssigner(session, fragment, outputDataSizeEstimates, sourcePartitioningScheme, targetPartitionSizeInBytes, standardSplitSizeInBytes, maxTaskSplitCount), callback, this.executor, this.splitBatchSize, standardSplitSizeInBytes, sourcePartitioningScheme, getSplitTimeRecorder);
    }

    private SplitAssigner createSplitAssigner(Session session, PlanFragment fragment, Map<PlanNodeId, OutputDataSizeEstimate> outputDataSizeEstimates, FaultTolerantPartitioningScheme sourcePartitioningScheme, long targetPartitionSizeInBytes, long standardSplitSizeInBytes, int maxArbitraryDistributionTaskSplitCount) {
        PartitioningHandle partitioning = fragment.getPartitioning();
        Set partitionedRemoteSources = (Set)fragment.getRemoteSourceNodes().stream().filter(node -> node.getExchangeType() != ExchangeNode.Type.REPLICATE).map(PlanNode::getId).collect(ImmutableSet.toImmutableSet());
        ImmutableSet partitionedSources = ImmutableSet.builder().addAll((Iterable)partitionedRemoteSources).addAll(fragment.getPartitionedSources()).build();
        Set replicatedSources = (Set)fragment.getRemoteSourceNodes().stream().filter(node -> node.getExchangeType() == ExchangeNode.Type.REPLICATE).map(PlanNode::getId).collect(ImmutableSet.toImmutableSet());
        boolean coordinatorOnly = partitioning.equals(SystemPartitioningHandle.COORDINATOR_DISTRIBUTION);
        if (partitioning.equals(SystemPartitioningHandle.SINGLE_DISTRIBUTION) || coordinatorOnly) {
            ImmutableSet hostRequirement = ImmutableSet.of();
            if (coordinatorOnly) {
                InternalNode currentNode = this.nodeManager.getCurrentNode();
                Verify.verify((boolean)currentNode.isCoordinator(), (String)"current node is expected to be a coordinator", (Object[])new Object[0]);
                hostRequirement = ImmutableSet.of((Object)currentNode.getHostAndPort());
            }
            return new SingleDistributionSplitAssigner((Set<HostAddress>)hostRequirement, (Set<PlanNodeId>)ImmutableSet.builder().addAll((Iterable)partitionedSources).addAll((Iterable)replicatedSources).build());
        }
        if (partitioning.equals(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION) || partitioning.equals(SystemPartitioningHandle.SCALED_WRITER_DISTRIBUTION) || partitioning.equals(SystemPartitioningHandle.SOURCE_DISTRIBUTION)) {
            return new ArbitraryDistributionSplitAssigner(partitioning.getCatalogHandle(), (Set<PlanNodeId>)partitionedSources, replicatedSources, targetPartitionSizeInBytes, standardSplitSizeInBytes, maxArbitraryDistributionTaskSplitCount);
        }
        if (partitioning.equals(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION) || partitioning.getCatalogHandle().isPresent() || partitioning.getConnectorHandle() instanceof MergePartitioningHandle) {
            return new HashDistributionSplitAssigner(partitioning.getCatalogHandle(), (Set<PlanNodeId>)partitionedSources, replicatedSources, SystemSessionProperties.getFaultTolerantExecutionTargetTaskInputSize(session).toBytes(), outputDataSizeEstimates, sourcePartitioningScheme, SystemSessionProperties.getFaultTolerantPreserveInputPartitionsInWriteStage(session) && EventDrivenTaskSourceFactory.isWriteFragment(fragment));
        }
        throw new IllegalArgumentException("Unexpected partitioning: " + partitioning);
    }

    private static boolean isWriteFragment(PlanFragment fragment) {
        PlanVisitor<Boolean, Void> visitor = new PlanVisitor<Boolean, Void>(){

            @Override
            protected Boolean visitPlan(PlanNode node, Void context) {
                for (PlanNode child : node.getSources()) {
                    if (!child.accept(this, context).booleanValue()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Boolean visitTableWriter(TableWriterNode node, Void context) {
                return true;
            }
        };
        return fragment.getRoot().accept(visitor, null);
    }
}

