/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import io.trino.connector.CatalogHandle;
import io.trino.execution.scheduler.EventDrivenTaskSource;
import io.trino.execution.scheduler.FaultTolerantPartitioningScheme;
import io.trino.execution.scheduler.NodeRequirements;
import io.trino.execution.scheduler.OutputDataSizeEstimate;
import io.trino.execution.scheduler.SplitAssigner;
import io.trino.metadata.InternalNode;
import io.trino.metadata.Split;
import io.trino.spi.HostAddress;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.IntStream;

class HashDistributionSplitAssigner
implements SplitAssigner {
    private final Optional<CatalogHandle> catalogRequirement;
    private final Set<PlanNodeId> replicatedSources;
    private final Set<PlanNodeId> allSources;
    private final FaultTolerantPartitioningScheme sourcePartitioningScheme;
    private final Map<Integer, TaskPartition> outputPartitionToTaskPartition;
    private final Set<Integer> createdTaskPartitions = new HashSet<Integer>();
    private final Set<PlanNodeId> completedSources = new HashSet<PlanNodeId>();
    private final ListMultimap<PlanNodeId, Split> replicatedSplits = ArrayListMultimap.create();
    private int nextTaskPartitionId;

    HashDistributionSplitAssigner(Optional<CatalogHandle> catalogRequirement, Set<PlanNodeId> partitionedSources, Set<PlanNodeId> replicatedSources, long targetPartitionSizeInBytes, Map<PlanNodeId, OutputDataSizeEstimate> outputDataSizeEstimates, FaultTolerantPartitioningScheme sourcePartitioningScheme, boolean preserveOutputPartitioning) {
        this.catalogRequirement = Objects.requireNonNull(catalogRequirement, "catalogRequirement is null");
        this.replicatedSources = ImmutableSet.copyOf((Collection)Objects.requireNonNull(replicatedSources, "replicatedSources is null"));
        this.allSources = ImmutableSet.builder().addAll(partitionedSources).addAll(replicatedSources).build();
        this.sourcePartitioningScheme = Objects.requireNonNull(sourcePartitioningScheme, "sourcePartitioningScheme is null");
        this.outputPartitionToTaskPartition = HashDistributionSplitAssigner.createOutputPartitionToTaskPartition(sourcePartitioningScheme, partitionedSources, outputDataSizeEstimates, preserveOutputPartitioning, targetPartitionSizeInBytes);
    }

    @Override
    public SplitAssigner.AssignmentResult assign(PlanNodeId planNodeId, ListMultimap<Integer, Split> splits, boolean noMoreSplits) {
        SplitAssigner.AssignmentResult.Builder assignment = SplitAssigner.AssignmentResult.builder();
        if (this.replicatedSources.contains(planNodeId)) {
            this.replicatedSplits.putAll((Object)planNodeId, (Iterable)splits.values());
            for (Integer partitionId : this.createdTaskPartitions) {
                assignment.updatePartition(new EventDrivenTaskSource.PartitionUpdate(partitionId, planNodeId, (List<Split>)ImmutableList.copyOf((Collection)splits.values()), noMoreSplits));
            }
        } else {
            for (Integer outputPartitionId : splits.keySet()) {
                int taskPartitionId;
                TaskPartition taskPartition = this.outputPartitionToTaskPartition.get(outputPartitionId);
                Verify.verify((taskPartition != null ? 1 : 0) != 0, (String)"taskPartition not found for outputPartitionId: %s", (Object)outputPartitionId);
                if (!taskPartition.isIdAssigned()) {
                    taskPartition.assignId(this.nextTaskPartitionId++);
                }
                if (!this.createdTaskPartitions.contains(taskPartitionId = taskPartition.getId())) {
                    Set hostRequirement = (Set)this.sourcePartitioningScheme.getNodeRequirement(outputPartitionId).map(InternalNode::getHostAndPort).map(ImmutableSet::of).orElse(ImmutableSet.of());
                    assignment.addPartition(new EventDrivenTaskSource.Partition(taskPartitionId, new NodeRequirements(this.catalogRequirement, hostRequirement)));
                    for (PlanNodeId replicatedSource : this.replicatedSplits.keySet()) {
                        assignment.updatePartition(new EventDrivenTaskSource.PartitionUpdate(taskPartitionId, replicatedSource, this.replicatedSplits.get((Object)replicatedSource), this.completedSources.contains(replicatedSource)));
                    }
                    for (PlanNodeId completedSource : this.completedSources) {
                        assignment.updatePartition(new EventDrivenTaskSource.PartitionUpdate(taskPartitionId, completedSource, (List<Split>)ImmutableList.of(), true));
                    }
                    this.createdTaskPartitions.add(taskPartitionId);
                }
                assignment.updatePartition(new EventDrivenTaskSource.PartitionUpdate(taskPartitionId, planNodeId, splits.get((Object)outputPartitionId), false));
            }
        }
        if (noMoreSplits) {
            this.completedSources.add(planNodeId);
            for (Integer taskPartition : this.createdTaskPartitions) {
                assignment.updatePartition(new EventDrivenTaskSource.PartitionUpdate(taskPartition, planNodeId, (List<Split>)ImmutableList.of(), true));
            }
            if (this.completedSources.containsAll(this.allSources)) {
                if (this.createdTaskPartitions.isEmpty()) {
                    assignment.addPartition(new EventDrivenTaskSource.Partition(0, new NodeRequirements(this.catalogRequirement, (Set<HostAddress>)ImmutableSet.of())));
                    for (PlanNodeId replicatedSource : this.replicatedSplits.keySet()) {
                        assignment.updatePartition(new EventDrivenTaskSource.PartitionUpdate(0, replicatedSource, this.replicatedSplits.get((Object)replicatedSource), true));
                    }
                    for (PlanNodeId completedSource : this.completedSources) {
                        assignment.updatePartition(new EventDrivenTaskSource.PartitionUpdate(0, completedSource, (List<Split>)ImmutableList.of(), true));
                    }
                    this.createdTaskPartitions.add(0);
                }
                for (Integer taskPartition : this.createdTaskPartitions) {
                    assignment.sealPartition(taskPartition);
                }
                assignment.setNoMorePartitions();
                this.replicatedSplits.clear();
            }
        }
        return assignment.build();
    }

    @Override
    public SplitAssigner.AssignmentResult finish() {
        Preconditions.checkState((!this.createdTaskPartitions.isEmpty() ? 1 : 0) != 0, (Object)"createdTaskPartitions is not expected to be empty");
        return SplitAssigner.AssignmentResult.builder().build();
    }

    private static Map<Integer, TaskPartition> createOutputPartitionToTaskPartition(FaultTolerantPartitioningScheme sourcePartitioningScheme, Set<PlanNodeId> partitionedSources, Map<PlanNodeId, OutputDataSizeEstimate> outputDataSizeEstimates, boolean preserveOutputPartitioning, long targetPartitionSizeInBytes) {
        int partitionCount = sourcePartitioningScheme.getPartitionCount();
        if (sourcePartitioningScheme.isExplicitPartitionToNodeMappingPresent() || partitionedSources.isEmpty() || !outputDataSizeEstimates.keySet().containsAll(partitionedSources) || preserveOutputPartitioning) {
            return (Map)IntStream.range(0, partitionCount).boxed().collect(ImmutableMap.toImmutableMap(Function.identity(), key -> new TaskPartition()));
        }
        List partitionedSourcesEstimates = (List)outputDataSizeEstimates.entrySet().stream().filter(entry -> partitionedSources.contains(entry.getKey())).map(Map.Entry::getValue).collect(ImmutableList.toImmutableList());
        OutputDataSizeEstimate mergedEstimate = OutputDataSizeEstimate.merge(partitionedSourcesEstimates);
        ImmutableMap.Builder result = ImmutableMap.builder();
        PriorityQueue<PartitionAssignment> assignments = new PriorityQueue<PartitionAssignment>();
        assignments.add(new PartitionAssignment(new TaskPartition(), 0L));
        for (int outputPartitionId = 0; outputPartitionId < partitionCount; ++outputPartitionId) {
            long outputPartitionSize = mergedEstimate.getPartitionSizeInBytes(outputPartitionId);
            if (((PartitionAssignment)assignments.peek()).assignedDataSizeInBytes() + outputPartitionSize > targetPartitionSizeInBytes && assignments.size() < partitionCount) {
                assignments.add(new PartitionAssignment(new TaskPartition(), 0L));
            }
            PartitionAssignment assignment = (PartitionAssignment)assignments.poll();
            result.put((Object)outputPartitionId, (Object)assignment.taskPartition());
            assignments.add(new PartitionAssignment(assignment.taskPartition(), assignment.assignedDataSizeInBytes() + outputPartitionSize));
        }
        return result.buildOrThrow();
    }

    private static class TaskPartition {
        private OptionalInt id = OptionalInt.empty();

        private TaskPartition() {
        }

        public void assignId(int id) {
            this.id = OptionalInt.of(id);
        }

        public boolean isIdAssigned() {
            return this.id.isPresent();
        }

        public int getId() {
            Preconditions.checkState((boolean)this.id.isPresent(), (Object)"id is expected to be assigned");
            return this.id.getAsInt();
        }
    }

    private record PartitionAssignment(TaskPartition taskPartition, long assignedDataSizeInBytes) implements Comparable<PartitionAssignment>
    {
        public PartitionAssignment(TaskPartition taskPartition, long assignedDataSizeInBytes) {
            this.taskPartition = Objects.requireNonNull(taskPartition, "taskPartition is null");
            this.assignedDataSizeInBytes = assignedDataSizeInBytes;
        }

        @Override
        public int compareTo(PartitionAssignment other) {
            return Long.compare(this.assignedDataSizeInBytes, other.assignedDataSizeInBytes);
        }
    }
}

