/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.primitives.ImmutableIntArray;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.trino.execution.scheduler.EventDrivenTaskSource;
import io.trino.metadata.Split;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
interface SplitAssigner {
    public AssignmentResult assign(PlanNodeId var1, ListMultimap<Integer, Split> var2, boolean var3);

    public AssignmentResult finish();

    public record AssignmentResult(List<EventDrivenTaskSource.Partition> partitionsAdded, boolean noMorePartitions, List<EventDrivenTaskSource.PartitionUpdate> partitionUpdates, ImmutableIntArray sealedPartitions) {
        public AssignmentResult {
            partitionsAdded = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionsAdded, "partitionsAdded is null"));
            partitionUpdates = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionUpdates, "partitionUpdates is null"));
        }

        public void update(EventDrivenTaskSource.Callback callback) {
            if (!this.partitionsAdded.isEmpty()) {
                callback.partitionsAdded(this.partitionsAdded);
            }
            if (this.noMorePartitions) {
                callback.noMorePartitions();
            }
            if (!this.partitionUpdates.isEmpty()) {
                callback.partitionsUpdated(this.partitionUpdates);
            }
            if (!this.sealedPartitions.isEmpty()) {
                callback.partitionsSealed(this.sealedPartitions);
            }
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private final ImmutableList.Builder<EventDrivenTaskSource.Partition> partitionsAdded = ImmutableList.builder();
            private boolean noMorePartitions;
            private final ImmutableList.Builder<EventDrivenTaskSource.PartitionUpdate> partitionUpdates = ImmutableList.builder();
            private final ImmutableIntArray.Builder sealedPartitions = ImmutableIntArray.builder();

            @CanIgnoreReturnValue
            public Builder addPartition(EventDrivenTaskSource.Partition partition) {
                this.partitionsAdded.add((Object)partition);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setNoMorePartitions() {
                this.noMorePartitions = true;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder updatePartition(EventDrivenTaskSource.PartitionUpdate partitionUpdate) {
                this.partitionUpdates.add((Object)partitionUpdate);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder sealPartition(int partitionId) {
                this.sealedPartitions.add(partitionId);
                return this;
            }

            public AssignmentResult build() {
                return new AssignmentResult((List<EventDrivenTaskSource.Partition>)this.partitionsAdded.build(), this.noMorePartitions, (List<EventDrivenTaskSource.PartitionUpdate>)this.partitionUpdates.build(), this.sealedPartitions.build());
            }
        }
    }
}

