/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import io.airlift.slice.SizeOf;
import io.trino.execution.scheduler.NodeRequirements;
import io.trino.metadata.Split;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class TaskDescriptor {
    private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(TaskDescriptor.class).instanceSize());
    private final int partitionId;
    private final ListMultimap<PlanNodeId, Split> splits;
    private final NodeRequirements nodeRequirements;
    private volatile transient long retainedSizeInBytes;

    public TaskDescriptor(int partitionId, ListMultimap<PlanNodeId, Split> splits, NodeRequirements nodeRequirements) {
        this.partitionId = partitionId;
        this.splits = ImmutableListMultimap.copyOf((Multimap)((Multimap)Objects.requireNonNull(splits, "splits is null")));
        this.nodeRequirements = Objects.requireNonNull(nodeRequirements, "nodeRequirements is null");
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public ListMultimap<PlanNodeId, Split> getSplits() {
        return this.splits;
    }

    public NodeRequirements getNodeRequirements() {
        return this.nodeRequirements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskDescriptor that = (TaskDescriptor)o;
        return this.partitionId == that.partitionId && Objects.equals(this.splits, that.splits) && Objects.equals(this.nodeRequirements, that.nodeRequirements);
    }

    public int hashCode() {
        return Objects.hash(this.partitionId, this.splits, this.nodeRequirements);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partitionId", this.partitionId).add("splits", this.splits).add("nodeRequirements", (Object)this.nodeRequirements).toString();
    }

    public long getRetainedSizeInBytes() {
        long result = this.retainedSizeInBytes;
        if (result == 0L) {
            this.retainedSizeInBytes = result = (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((Map)Multimaps.asMap(this.splits), PlanNodeId::getRetainedSizeInBytes, splits -> SizeOf.estimatedSizeOf((List)splits, Split::getRetainedSizeInBytes)) + this.nodeRequirements.getRetainedSizeInBytes();
        }
        return result;
    }
}

