/*
 * Decompiled with CFR 0.152.
 */
package io.trino.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.trino.json.CachingResolver;
import io.trino.json.JsonPathEvaluator;
import io.trino.json.PathEvaluationContext;
import io.trino.json.PathEvaluationError;
import io.trino.json.PathEvaluationUtil;
import io.trino.json.PathEvaluationVisitor;
import io.trino.json.ir.IrComparisonPredicate;
import io.trino.json.ir.IrConjunctionPredicate;
import io.trino.json.ir.IrDisjunctionPredicate;
import io.trino.json.ir.IrExistsPredicate;
import io.trino.json.ir.IrIsUnknownPredicate;
import io.trino.json.ir.IrJsonPathVisitor;
import io.trino.json.ir.IrNegationPredicate;
import io.trino.json.ir.IrPathNode;
import io.trino.json.ir.IrPredicate;
import io.trino.json.ir.IrStartsWithPredicate;
import io.trino.json.ir.SqlJsonLiteralConverter;
import io.trino.json.ir.TypedValue;
import io.trino.operator.scalar.StringFunctions;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.ExpressionAnalyzer;
import io.trino.sql.tree.ComparisonExpression;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class PathPredicateEvaluationVisitor
extends IrJsonPathVisitor<Boolean, PathEvaluationContext> {
    private final boolean lax;
    private final PathEvaluationVisitor pathVisitor;
    private final JsonPathEvaluator.Invoker invoker;
    private final CachingResolver resolver;

    public PathPredicateEvaluationVisitor(boolean lax, PathEvaluationVisitor pathVisitor, JsonPathEvaluator.Invoker invoker, CachingResolver resolver) {
        this.lax = lax;
        this.pathVisitor = Objects.requireNonNull(pathVisitor, "pathVisitor is null");
        this.invoker = Objects.requireNonNull(invoker, "invoker is null");
        this.resolver = Objects.requireNonNull(resolver, "resolver is null");
    }

    @Override
    protected Boolean visitIrPathNode(IrPathNode node, PathEvaluationContext context) {
        throw new IllegalStateException("JSON predicate evaluating visitor applied to a non-predicate node " + node.getClass().getSimpleName());
    }

    @Override
    protected Boolean visitIrPredicate(IrPredicate node, PathEvaluationContext context) {
        throw new UnsupportedOperationException("JSON predicate evaluating visitor not implemented for " + node.getClass().getSimpleName());
    }

    @Override
    protected Boolean visitIrComparisonPredicate(IrComparisonPredicate node, PathEvaluationContext context) {
        List<Object> rightSequence;
        List<Object> leftSequence;
        try {
            leftSequence = (List<Object>)this.pathVisitor.process(node.getLeft(), context);
        }
        catch (PathEvaluationError e) {
            return null;
        }
        try {
            rightSequence = (List<Object>)this.pathVisitor.process(node.getRight(), context);
        }
        catch (PathEvaluationError e) {
            return null;
        }
        if (this.lax) {
            leftSequence = PathEvaluationUtil.unwrapArrays(leftSequence);
            rightSequence = PathEvaluationUtil.unwrapArrays(rightSequence);
        }
        if (leftSequence.isEmpty() || rightSequence.isEmpty()) {
            return Boolean.FALSE;
        }
        boolean leftHasJsonNull = false;
        boolean leftHasScalar = false;
        boolean leftHasNonScalar = false;
        for (Object object : leftSequence) {
            if (object instanceof JsonNode) {
                if (object instanceof NullNode) {
                    leftHasJsonNull = true;
                    continue;
                }
                if (((JsonNode)object).isValueNode()) {
                    leftHasScalar = true;
                    continue;
                }
                leftHasNonScalar = true;
                continue;
            }
            leftHasScalar = true;
        }
        boolean rightHasJsonNull = false;
        boolean rightHasScalar = false;
        boolean rightHasNonScalar = false;
        for (Object object : rightSequence) {
            if (object instanceof JsonNode) {
                if (((JsonNode)object).isNull()) {
                    rightHasJsonNull = true;
                    continue;
                }
                if (((JsonNode)object).isValueNode()) {
                    rightHasScalar = true;
                    continue;
                }
                rightHasNonScalar = true;
                continue;
            }
            rightHasScalar = true;
        }
        if (leftHasNonScalar && rightHasNonScalar || leftHasNonScalar && rightHasScalar || leftHasScalar && rightHasNonScalar) {
            return null;
        }
        boolean found = false;
        if (node.getOperator() == IrComparisonPredicate.Operator.EQUAL && leftHasJsonNull && rightHasJsonNull) {
            found = true;
        }
        if (node.getOperator() == IrComparisonPredicate.Operator.NOT_EQUAL && (leftHasJsonNull && (rightHasScalar || rightHasNonScalar) || rightHasJsonNull && (leftHasScalar || leftHasNonScalar))) {
            found = true;
        }
        if (found && this.lax) {
            return Boolean.TRUE;
        }
        if (!leftHasScalar || !rightHasScalar) {
            return found;
        }
        List<TypedValue> leftScalars = PathPredicateEvaluationVisitor.getScalars(leftSequence);
        if (leftScalars == null) {
            return null;
        }
        List<TypedValue> rightScalars = PathPredicateEvaluationVisitor.getScalars(rightSequence);
        if (rightScalars == null) {
            return null;
        }
        for (TypedValue leftValue : leftScalars) {
            for (TypedValue rightValue : rightScalars) {
                Boolean result = this.compare(node, leftValue, rightValue);
                if (result == null) {
                    return null;
                }
                if (!Boolean.TRUE.equals(result)) continue;
                found = true;
                if (!this.lax) continue;
                return Boolean.TRUE;
            }
        }
        return found;
    }

    private Boolean compare(IrComparisonPredicate node, TypedValue left, TypedValue right) {
        Object result;
        ComparisonExpression.Operator operator;
        IrComparisonPredicate.Operator comparisonOperator = node.getOperator();
        Type firstType = left.getType();
        Object firstValue = left.getValueAsObject();
        Type secondType = right.getType();
        Object secondValue = right.getValueAsObject();
        switch (comparisonOperator) {
            case EQUAL: 
            case NOT_EQUAL: {
                operator = ComparisonExpression.Operator.EQUAL;
                break;
            }
            case LESS_THAN: {
                operator = ComparisonExpression.Operator.LESS_THAN;
                break;
            }
            case GREATER_THAN: {
                operator = ComparisonExpression.Operator.LESS_THAN;
                firstType = right.getType();
                firstValue = right.getValueAsObject();
                secondType = left.getType();
                secondValue = left.getValueAsObject();
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                operator = ComparisonExpression.Operator.LESS_THAN_OR_EQUAL;
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                operator = ComparisonExpression.Operator.LESS_THAN_OR_EQUAL;
                firstType = right.getType();
                firstValue = right.getValueAsObject();
                secondType = left.getType();
                secondValue = left.getValueAsObject();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unexpected comparison operator " + comparisonOperator);
            }
        }
        CachingResolver.ResolvedOperatorAndCoercions operators = this.resolver.getOperators(node, OperatorType.valueOf((String)operator.name()), firstType, secondType);
        if (operators == CachingResolver.ResolvedOperatorAndCoercions.RESOLUTION_ERROR) {
            return null;
        }
        if (operators.getLeftCoercion().isPresent()) {
            try {
                firstValue = this.invoker.invoke(operators.getLeftCoercion().get(), (List<Object>)ImmutableList.of((Object)firstValue));
            }
            catch (RuntimeException e) {
                return null;
            }
        }
        if (operators.getRightCoercion().isPresent()) {
            try {
                secondValue = this.invoker.invoke(operators.getRightCoercion().get(), (List<Object>)ImmutableList.of((Object)secondValue));
            }
            catch (RuntimeException e) {
                return null;
            }
        }
        try {
            result = this.invoker.invoke(operators.getOperator(), (List<Object>)ImmutableList.of((Object)firstValue, (Object)secondValue));
        }
        catch (RuntimeException e) {
            return null;
        }
        if (comparisonOperator == IrComparisonPredicate.Operator.NOT_EQUAL) {
            return (Boolean)result == false;
        }
        return (Boolean)result;
    }

    @Override
    protected Boolean visitIrConjunctionPredicate(IrConjunctionPredicate node, PathEvaluationContext context) {
        Boolean left = (Boolean)this.process(node.getLeft(), context);
        if (Boolean.FALSE.equals(left)) {
            return Boolean.FALSE;
        }
        Boolean right = (Boolean)this.process(node.getRight(), context);
        if (Boolean.FALSE.equals(right)) {
            return Boolean.FALSE;
        }
        if (left == null || right == null) {
            return null;
        }
        return Boolean.TRUE;
    }

    @Override
    protected Boolean visitIrDisjunctionPredicate(IrDisjunctionPredicate node, PathEvaluationContext context) {
        Boolean left = (Boolean)this.process(node.getLeft(), context);
        if (Boolean.TRUE.equals(left)) {
            return Boolean.TRUE;
        }
        Boolean right = (Boolean)this.process(node.getRight(), context);
        if (Boolean.TRUE.equals(right)) {
            return Boolean.TRUE;
        }
        if (left == null || right == null) {
            return null;
        }
        return Boolean.FALSE;
    }

    @Override
    protected Boolean visitIrExistsPredicate(IrExistsPredicate node, PathEvaluationContext context) {
        List sequence;
        try {
            sequence = (List)this.pathVisitor.process(node.getPath(), context);
        }
        catch (PathEvaluationError e) {
            return null;
        }
        return !sequence.isEmpty();
    }

    @Override
    protected Boolean visitIrIsUnknownPredicate(IrIsUnknownPredicate node, PathEvaluationContext context) {
        Boolean predicateResult = (Boolean)this.process(node.getPredicate(), context);
        return predicateResult == null;
    }

    @Override
    protected Boolean visitIrNegationPredicate(IrNegationPredicate node, PathEvaluationContext context) {
        Boolean predicateResult = (Boolean)this.process(node.getPredicate(), context);
        return predicateResult == null ? null : Boolean.valueOf(predicateResult == false);
    }

    @Override
    protected Boolean visitIrStartsWithPredicate(IrStartsWithPredicate node, PathEvaluationContext context) {
        List prefixSequence;
        List<Object> valueSequence;
        try {
            valueSequence = (List<Object>)this.pathVisitor.process(node.getValue(), context);
        }
        catch (PathEvaluationError e) {
            return null;
        }
        try {
            prefixSequence = (List)this.pathVisitor.process(node.getPrefix(), context);
        }
        catch (PathEvaluationError e) {
            return null;
        }
        if (prefixSequence.size() != 1) {
            return null;
        }
        Slice prefix = PathPredicateEvaluationVisitor.getText(Iterables.getOnlyElement((Iterable)prefixSequence));
        if (prefix == null) {
            return null;
        }
        if (this.lax) {
            valueSequence = PathEvaluationUtil.unwrapArrays(valueSequence);
        }
        if (valueSequence.isEmpty()) {
            return Boolean.FALSE;
        }
        boolean found = false;
        for (Object object : valueSequence) {
            Slice value = PathPredicateEvaluationVisitor.getText(object);
            if (value == null) {
                return null;
            }
            if (!StringFunctions.startsWith(value, prefix)) continue;
            found = true;
            if (!this.lax) continue;
            return Boolean.TRUE;
        }
        return found;
    }

    private static List<TypedValue> getScalars(List<Object> sequence) {
        ImmutableList.Builder scalars = ImmutableList.builder();
        for (Object object : sequence) {
            Optional<TypedValue> typedValue;
            if (object instanceof TypedValue) {
                scalars.add((Object)((TypedValue)object));
                continue;
            }
            JsonNode jsonNode = (JsonNode)object;
            if (!jsonNode.isValueNode() || jsonNode.isNull()) continue;
            try {
                typedValue = SqlJsonLiteralConverter.getTypedValue(jsonNode);
            }
            catch (SqlJsonLiteralConverter.JsonLiteralConversionError e) {
                return null;
            }
            if (typedValue.isEmpty()) {
                return null;
            }
            scalars.add((Object)typedValue.get());
        }
        return scalars.build();
    }

    private static Slice getText(Object object) {
        if (object instanceof TypedValue) {
            TypedValue typedValue = (TypedValue)object;
            if (ExpressionAnalyzer.isCharacterStringType(typedValue.getType())) {
                if (typedValue.getType() instanceof CharType) {
                    return Chars.padSpaces((Slice)((Slice)typedValue.getObjectValue()), (CharType)((CharType)typedValue.getType()));
                }
                return (Slice)typedValue.getObjectValue();
            }
            return null;
        }
        JsonNode jsonNode = (JsonNode)object;
        return SqlJsonLiteralConverter.getTextTypedValue(jsonNode).map(TypedValue::getObjectValue).map(Slice.class::cast).orElse(null);
    }
}

