/*
 * Decompiled with CFR 0.152.
 */
package io.trino.json.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.json.ir.IrAccessor;
import io.trino.json.ir.IrJsonPathVisitor;
import io.trino.json.ir.IrPathNode;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class IrArrayAccessor
extends IrAccessor {
    private final List<Subscript> subscripts;

    @JsonCreator
    public IrArrayAccessor(@JsonProperty(value="base") IrPathNode base, @JsonProperty(value="subscripts") List<Subscript> subscripts, @JsonProperty(value="type") Optional<Type> type) {
        super(base, type);
        this.subscripts = Objects.requireNonNull(subscripts, "subscripts is null");
    }

    @Override
    protected <R, C> R accept(IrJsonPathVisitor<R, C> visitor, C context) {
        return visitor.visitIrArrayAccessor(this, context);
    }

    @JsonProperty
    public List<Subscript> getSubscripts() {
        return this.subscripts;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IrArrayAccessor other = (IrArrayAccessor)obj;
        return Objects.equals(this.base, other.base) && Objects.equals(this.subscripts, other.subscripts);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.base, this.subscripts);
    }

    public static class Subscript {
        private final IrPathNode from;
        private final Optional<IrPathNode> to;

        @JsonCreator
        public Subscript(@JsonProperty(value="from") IrPathNode from, @JsonProperty(value="to") Optional<IrPathNode> to) {
            this.from = Objects.requireNonNull(from, "from is null");
            this.to = Objects.requireNonNull(to, "to is null");
        }

        @JsonProperty
        public IrPathNode getFrom() {
            return this.from;
        }

        @JsonProperty
        public Optional<IrPathNode> getTo() {
            return this.to;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Subscript other = (Subscript)obj;
            return Objects.equals(this.from, other.from) && Objects.equals(this.to, other.to);
        }

        public int hashCode() {
            return Objects.hash(this.from, this.to);
        }
    }
}

