/*
 * Decompiled with CFR 0.152.
 */
package io.trino.json.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.json.ir.IrPathNode;
import java.util.Objects;

public class IrJsonPath {
    private final boolean lax;
    private final IrPathNode root;

    @JsonCreator
    public IrJsonPath(@JsonProperty(value="lax") boolean lax, @JsonProperty(value="root") IrPathNode root) {
        this.lax = lax;
        this.root = Objects.requireNonNull(root, "root is null");
    }

    @JsonProperty
    public boolean isLax() {
        return this.lax;
    }

    @JsonProperty
    public IrPathNode getRoot() {
        return this.root;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IrJsonPath other = (IrJsonPath)obj;
        return this.lax == other.lax && Objects.equals(this.root, other.root);
    }

    public int hashCode() {
        return Objects.hash(this.lax, this.root);
    }
}

