/*
 * Decompiled with CFR 0.152.
 */
package io.trino.json.ir;

import com.google.common.base.Preconditions;
import io.trino.spi.type.Type;
import java.util.Objects;

public class TypedValue {
    private final Type type;
    private final Object objectValue;
    private final long longValue;
    private final double doubleValue;
    private final boolean booleanValue;
    private final Object valueAsObject;

    public TypedValue(Type type, Object objectValue) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(objectValue, "value is null");
        Preconditions.checkArgument((boolean)type.getJavaType().isAssignableFrom(objectValue.getClass()), (String)"%s value does not match the type %s", objectValue.getClass(), (Object)type);
        this.type = type;
        this.objectValue = objectValue;
        this.longValue = 0L;
        this.doubleValue = 0.0;
        this.booleanValue = false;
        this.valueAsObject = objectValue;
    }

    public TypedValue(Type type, long longValue) {
        Objects.requireNonNull(type, "type is null");
        Preconditions.checkArgument((boolean)Long.TYPE.equals(type.getJavaType()), (String)"long value does not match the type %s", (Object)type);
        this.type = type;
        this.objectValue = null;
        this.longValue = longValue;
        this.doubleValue = 0.0;
        this.booleanValue = false;
        this.valueAsObject = longValue;
    }

    public TypedValue(Type type, double doubleValue) {
        Objects.requireNonNull(type, "type is null");
        Preconditions.checkArgument((boolean)Double.TYPE.equals(type.getJavaType()), (String)"double value does not match the type %s", (Object)type);
        this.type = type;
        this.objectValue = null;
        this.longValue = 0L;
        this.doubleValue = doubleValue;
        this.booleanValue = false;
        this.valueAsObject = doubleValue;
    }

    public TypedValue(Type type, boolean booleanValue) {
        Objects.requireNonNull(type, "type is null");
        Preconditions.checkArgument((boolean)Boolean.TYPE.equals(type.getJavaType()), (String)"boolean value does not match the type %s", (Object)type);
        this.type = type;
        this.objectValue = null;
        this.longValue = 0L;
        this.doubleValue = 0.0;
        this.booleanValue = booleanValue;
        this.valueAsObject = booleanValue;
    }

    public static TypedValue fromValueAsObject(Type type, Object valueAsObject) {
        if (Long.TYPE.equals(type.getJavaType())) {
            Preconditions.checkState((boolean)(valueAsObject instanceof Long), (String)"%s value does not match the type %s", valueAsObject.getClass(), (Object)type);
            return new TypedValue(type, (Long)valueAsObject);
        }
        if (Double.TYPE.equals(type.getJavaType())) {
            Preconditions.checkState((boolean)(valueAsObject instanceof Double), (String)"%s value does not match the type %s", valueAsObject.getClass(), (Object)type);
            return new TypedValue(type, (Double)valueAsObject);
        }
        if (Boolean.TYPE.equals(type.getJavaType())) {
            Preconditions.checkState((boolean)(valueAsObject instanceof Boolean), (String)"%s value does not match the type %s", valueAsObject.getClass(), (Object)type);
            return new TypedValue(type, (Boolean)valueAsObject);
        }
        Preconditions.checkState((boolean)type.getJavaType().isAssignableFrom(valueAsObject.getClass()), (String)"%s value does not match the type %s", valueAsObject.getClass(), (Object)type);
        return new TypedValue(type, valueAsObject);
    }

    public Type getType() {
        return this.type;
    }

    public Object getObjectValue() {
        Preconditions.checkArgument((this.objectValue != null ? 1 : 0) != 0, (String)"the type %s is represented as %s. call another method to retrieve the value", (Object)this.type, (Object)this.type.getJavaType());
        Preconditions.checkArgument((boolean)this.type.getJavaType().isAssignableFrom(this.objectValue.getClass()), (String)"%s value does not match the type %s", this.objectValue.getClass(), (Object)this.type);
        return this.objectValue;
    }

    public long getLongValue() {
        Preconditions.checkArgument((boolean)Long.TYPE.equals(this.type.getJavaType()), (String)"long value does not match the type %s", (Object)this.type);
        return this.longValue;
    }

    public double getDoubleValue() {
        Preconditions.checkArgument((boolean)Double.TYPE.equals(this.type.getJavaType()), (String)"double value does not match the type %s", (Object)this.type);
        return this.doubleValue;
    }

    public boolean getBooleanValue() {
        Preconditions.checkArgument((boolean)Boolean.TYPE.equals(this.type.getJavaType()), (String)"boolean value does not match the type %s", (Object)this.type);
        return this.booleanValue;
    }

    public Object getValueAsObject() {
        return this.valueAsObject;
    }
}

