/*
 * Decompiled with CFR 0.152.
 */
package io.trino.likematcher;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

record DFA(State start, State failed, List<State> states, Map<Integer, List<Transition>> transitions) {
    DFA {
        Objects.requireNonNull(start, "start is null");
        Objects.requireNonNull(failed, "failed is null");
        states = ImmutableList.copyOf(states);
        transitions = ImmutableMap.copyOf(transitions);
    }

    public List<Transition> transitions(State state) {
        return this.transitions.get(state.id);
    }

    record State(int id, String label, boolean accept) {
        @Override
        public String toString() {
            return "%s:%s%s".formatted(this.id, this.accept ? "*" : "", this.label);
        }
    }

    public static class Builder {
        private int nextId;
        private State start;
        private State failed;
        private final List<State> states = new ArrayList<State>();
        private final Map<Integer, List<Transition>> transitions = new HashMap<Integer, List<Transition>>();

        public State addState(String label, boolean accept) {
            State state = new State(this.nextId++, label, accept);
            this.states.add(state);
            return state;
        }

        public State addStartState(String label, boolean accept) {
            State state;
            Preconditions.checkState((this.start == null ? 1 : 0) != 0, (Object)"Start state already set");
            this.start = state = this.addState(label, accept);
            return state;
        }

        public State addFailState() {
            State state;
            Preconditions.checkState((this.failed == null ? 1 : 0) != 0, (Object)"Fail state already set");
            this.failed = state = this.addState("fail", false);
            return state;
        }

        public void addTransition(State from, int value, State to) {
            this.transitions.computeIfAbsent(from.id(), key -> new ArrayList()).add(new Transition(value, to));
        }

        public DFA build() {
            return new DFA(this.start, this.failed, this.states, this.transitions);
        }
    }

    record Transition(int value, State target) {
        @Override
        public String toString() {
            return String.format("-[%s]-> %s", this.value, this.target);
        }
    }
}

