/*
 * Decompiled with CFR 0.152.
 */
package io.trino.likematcher;

import io.trino.likematcher.DFA;

class DenseDfaMatcher {
    private final int[] transitions;
    private final int start;
    private final boolean[] accept;
    private final int fail;
    private final boolean exact;

    public static DenseDfaMatcher newInstance(DFA dfa, boolean exact) {
        int[] transitions = new int[dfa.states().size() * 256];
        boolean[] accept = new boolean[dfa.states().size()];
        for (DFA.State state : dfa.states()) {
            for (DFA.Transition transition : dfa.transitions(state)) {
                transitions[state.id() * 256 + transition.value()] = transition.target().id() * 256;
            }
            if (!state.accept()) continue;
            accept[state.id()] = true;
        }
        return new DenseDfaMatcher(transitions, dfa.start().id(), accept, 0, exact);
    }

    private DenseDfaMatcher(int[] transitions, int start, boolean[] accept, int fail, boolean exact) {
        this.transitions = transitions;
        this.start = start;
        this.accept = accept;
        this.fail = fail;
        this.exact = exact;
    }

    public boolean match(byte[] input, int offset, int length) {
        if (this.exact) {
            return this.exactMatch(input, offset, length);
        }
        return this.prefixMatch(input, offset, length);
    }

    private boolean exactMatch(byte[] input, int offset, int length) {
        int state = this.start << 8;
        for (int i = offset; i < offset + length; ++i) {
            byte inputByte = input[i];
            if ((state = this.transitions[state | inputByte & 0xFF]) != this.fail) continue;
            return false;
        }
        return this.accept[state >>> 8];
    }

    private boolean prefixMatch(byte[] input, int offset, int length) {
        int state = this.start << 8;
        for (int i = offset; i < offset + length; ++i) {
            byte inputByte = input[i];
            if ((state = this.transitions[state | inputByte & 0xFF]) == this.fail) {
                return false;
            }
            if (!this.accept[state >>> 8]) continue;
            return true;
        }
        return this.accept[state >>> 8];
    }
}

