/*
 * Decompiled with CFR 0.152.
 */
package io.trino.likematcher;

import com.google.common.base.Preconditions;
import io.trino.likematcher.DenseDfaMatcher;
import io.trino.likematcher.NFA;
import io.trino.likematcher.Pattern;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;

public class LikeMatcher {
    private final String pattern;
    private final Optional<Character> escape;
    private final int minSize;
    private final OptionalInt maxSize;
    private final byte[] prefix;
    private final byte[] suffix;
    private final Optional<DenseDfaMatcher> matcher;

    private LikeMatcher(String pattern, Optional<Character> escape, int minSize, OptionalInt maxSize, byte[] prefix, byte[] suffix, Optional<DenseDfaMatcher> matcher) {
        this.pattern = pattern;
        this.escape = escape;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.prefix = prefix;
        this.suffix = suffix;
        this.matcher = matcher;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Optional<Character> getEscape() {
        return this.escape;
    }

    public static LikeMatcher compile(String pattern) {
        return LikeMatcher.compile(pattern, Optional.empty());
    }

    public static LikeMatcher compile(String pattern, Optional<Character> escape) {
        Pattern.Any last;
        List<Pattern> parsed = LikeMatcher.parse(pattern, escape);
        List<Pattern> optimized = LikeMatcher.optimize(parsed);
        int minSize = 0;
        int maxSize = 0;
        boolean unbounded = false;
        for (Pattern expression : optimized) {
            int length;
            if (expression instanceof Pattern.Literal) {
                Pattern.Literal literal = (Pattern.Literal)expression;
                length = literal.value().getBytes(StandardCharsets.UTF_8).length;
                minSize += length;
                maxSize += length;
                continue;
            }
            if (expression instanceof Pattern.Any) {
                Pattern.Any any = (Pattern.Any)expression;
                length = any.min();
                minSize += length;
                maxSize += length * 4;
                unbounded = unbounded || any.unbounded();
                continue;
            }
            throw new UnsupportedOperationException("Not supported: " + expression.getClass().getName());
        }
        byte[] prefix = new byte[]{};
        byte[] suffix = new byte[]{};
        ArrayList<Pattern> middle = new ArrayList<Pattern>();
        for (int i = 0; i < optimized.size(); ++i) {
            Pattern expression = optimized.get(i);
            if (i == 0) {
                if (expression instanceof Pattern.Literal) {
                    literal = (Pattern.Literal)expression;
                    prefix = literal.value().getBytes(StandardCharsets.UTF_8);
                    continue;
                }
            } else if (i == optimized.size() - 1 && expression instanceof Pattern.Literal) {
                literal = (Pattern.Literal)expression;
                suffix = literal.value().getBytes(StandardCharsets.UTF_8);
                continue;
            }
            middle.add(expression);
        }
        boolean exact = true;
        if (!middle.isEmpty() && (last = (Pattern.Any)middle.get(middle.size() - 1)).unbounded()) {
            exact = false;
            if (last.min() == 0) {
                middle.remove(middle.size() - 1);
            } else {
                middle.set(middle.size() - 1, new Pattern.Any(last.min(), false));
            }
        }
        Optional<DenseDfaMatcher> matcher = Optional.empty();
        if (!middle.isEmpty()) {
            matcher = Optional.of(DenseDfaMatcher.newInstance(LikeMatcher.makeNfa(middle).toDfa(), exact));
        }
        return new LikeMatcher(pattern, escape, minSize, unbounded ? OptionalInt.empty() : OptionalInt.of(maxSize), prefix, suffix, matcher);
    }

    public boolean match(byte[] input) {
        return this.match(input, 0, input.length);
    }

    public boolean match(byte[] input, int offset, int length) {
        if (length < this.minSize) {
            return false;
        }
        if (this.maxSize.isPresent() && length > this.maxSize.getAsInt()) {
            return false;
        }
        if (!this.startsWith(this.prefix, input, offset)) {
            return false;
        }
        if (!this.startsWith(this.suffix, input, offset + length - this.suffix.length)) {
            return false;
        }
        if (this.matcher.isPresent()) {
            return this.matcher.get().match(input, offset + this.prefix.length, length - this.suffix.length - this.prefix.length);
        }
        return true;
    }

    private boolean startsWith(byte[] pattern, byte[] input, int offset) {
        for (int i = 0; i < pattern.length; ++i) {
            if (pattern[i] == input[offset + i]) continue;
            return false;
        }
        return true;
    }

    private static List<Pattern> parse(String pattern, Optional<Character> escape) {
        ArrayList<Pattern> result = new ArrayList<Pattern>();
        StringBuilder literal = new StringBuilder();
        boolean inEscape = false;
        for (int i = 0; i < pattern.length(); ++i) {
            char character = pattern.charAt(i);
            if (inEscape) {
                if (character != '%' && character != '_' && character != escape.get().charValue()) {
                    throw new IllegalArgumentException("Escape character must be followed by '%', '_' or the escape character itself");
                }
                literal.append(character);
                inEscape = false;
                continue;
            }
            if (escape.isPresent() && character == escape.get().charValue()) {
                inEscape = true;
                continue;
            }
            if (character == '%' || character == '_') {
                if (literal.length() != 0) {
                    result.add(new Pattern.Literal(literal.toString()));
                    literal = new StringBuilder();
                }
                if (character == '%') {
                    result.add(new Pattern.Any(0, true));
                    continue;
                }
                result.add(new Pattern.Any(1, false));
                continue;
            }
            literal.append(character);
        }
        if (inEscape) {
            throw new IllegalArgumentException("Escape character must be followed by '%', '_' or the escape character itself");
        }
        if (literal.length() != 0) {
            result.add(new Pattern.Literal(literal.toString()));
        }
        return result;
    }

    private static List<Pattern> optimize(List<Pattern> pattern) {
        if (pattern.isEmpty()) {
            return pattern;
        }
        ArrayList<Pattern> result = new ArrayList<Pattern>();
        int anyPatternStart = -1;
        for (int i = 0; i < pattern.size(); ++i) {
            Pattern current = pattern.get(i);
            if (anyPatternStart == -1 && current instanceof Pattern.Any) {
                anyPatternStart = i;
                continue;
            }
            if (!(current instanceof Pattern.Literal)) continue;
            if (anyPatternStart != -1) {
                result.add(LikeMatcher.collapse(pattern, anyPatternStart, i));
            }
            result.add(current);
            anyPatternStart = -1;
        }
        if (anyPatternStart != -1) {
            result.add(LikeMatcher.collapse(pattern, anyPatternStart, pattern.size()));
        }
        return result;
    }

    private static Pattern.Any collapse(List<Pattern> pattern, int start, int end) {
        int min = 0;
        boolean unbounded = false;
        for (int i = start; i < end; ++i) {
            Pattern.Any any = (Pattern.Any)pattern.get(i);
            min += any.min();
            unbounded = unbounded || any.unbounded();
        }
        return new Pattern.Any(min, unbounded);
    }

    private static NFA makeNfa(List<Pattern> pattern) {
        Preconditions.checkArgument((!pattern.isEmpty() ? 1 : 0) != 0, (Object)"pattern is empty");
        NFA.Builder builder = new NFA.Builder();
        NFA.State state = builder.addStartState();
        for (Pattern item : pattern) {
            if (item instanceof Pattern.Literal) {
                Pattern.Literal literal = (Pattern.Literal)item;
                for (byte current : literal.value().getBytes(StandardCharsets.UTF_8)) {
                    state = LikeMatcher.matchByte(builder, state, current);
                }
                continue;
            }
            if (item instanceof Pattern.Any) {
                NFA.State previous;
                Pattern.Any any = (Pattern.Any)item;
                int i = 0;
                do {
                    previous = state;
                    state = LikeMatcher.matchSingleUtf8(builder, state);
                } while (++i < any.min());
                if (any.min() == 0) {
                    builder.addTransition(previous, new NFA.Epsilon(), state);
                }
                if (!any.unbounded()) continue;
                builder.addTransition(state, new NFA.Epsilon(), previous);
                continue;
            }
            throw new UnsupportedOperationException("Not supported: " + item.getClass().getName());
        }
        builder.setAccept(state);
        return builder.build();
    }

    private static NFA.State matchByte(NFA.Builder builder, NFA.State state, byte value) {
        NFA.State next = builder.addState();
        builder.addTransition(state, new NFA.Value(value), next);
        return next;
    }

    private static NFA.State matchSingleUtf8(NFA.Builder builder, NFA.State start) {
        NFA.State next = builder.addState();
        builder.addTransition(start, new NFA.Prefix(0, 1), next);
        NFA.State state1 = builder.addState();
        NFA.State state2 = builder.addState();
        NFA.State state3 = builder.addState();
        builder.addTransition(start, new NFA.Prefix(30, 5), state1);
        builder.addTransition(start, new NFA.Prefix(14, 4), state2);
        builder.addTransition(start, new NFA.Prefix(6, 3), state3);
        builder.addTransition(state1, new NFA.Prefix(2, 2), state2);
        builder.addTransition(state2, new NFA.Prefix(2, 2), state3);
        builder.addTransition(state3, new NFA.Prefix(2, 2), next);
        return next;
    }
}

