/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.connector.CatalogHandle;
import io.trino.connector.CatalogServiceProvider;
import io.trino.metadata.PropertyUtil;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.session.PropertyMetadata;
import io.trino.sql.PlannerContext;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.Property;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

abstract class AbstractCatalogPropertyManager {
    private final String propertyType;
    private final ErrorCodeSupplier propertyError;
    private final CatalogServiceProvider<Map<String, PropertyMetadata<?>>> connectorProperties;

    protected AbstractCatalogPropertyManager(String propertyType, ErrorCodeSupplier propertyError, CatalogServiceProvider<Map<String, PropertyMetadata<?>>> connectorProperties) {
        this.propertyType = Objects.requireNonNull(propertyType, "propertyType is null");
        this.propertyError = Objects.requireNonNull(propertyError, "propertyError is null");
        this.connectorProperties = Objects.requireNonNull(connectorProperties, "connectorProperties is null");
    }

    public Map<String, Object> getProperties(String catalogName, CatalogHandle catalogHandle, Iterable<Property> properties, Session session, PlannerContext plannerContext, AccessControl accessControl, Map<NodeRef<Parameter>, Expression> parameters, boolean includeAllProperties) {
        Map<String, Optional<Object>> nullableValues = this.getNullableProperties(catalogName, catalogHandle, properties, session, plannerContext, accessControl, parameters, includeAllProperties);
        return (Map)nullableValues.entrySet().stream().filter(entry -> ((Optional)entry.getValue()).isPresent()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((Optional)entry.getValue()).orElseThrow()));
    }

    public Map<String, Optional<Object>> getNullableProperties(String catalogName, CatalogHandle catalogHandle, Iterable<Property> properties, Session session, PlannerContext plannerContext, AccessControl accessControl, Map<NodeRef<Parameter>, Expression> parameters, boolean includeAllProperties) {
        Map<String, PropertyMetadata<?>> propertyMetadata = this.connectorProperties.getService(catalogHandle);
        return PropertyUtil.evaluateProperties(properties, session, plannerContext, accessControl, parameters, includeAllProperties, propertyMetadata, this.propertyError, String.format("catalog '%s' %s property", catalogName, this.propertyType));
    }

    public Collection<PropertyMetadata<?>> getAllProperties(CatalogHandle catalogHandle) {
        return this.connectorProperties.getService(catalogHandle).values();
    }
}

